/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.mobile.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.common.TemplateWizard;
import org.eclipse.dirigible.ide.template.ui.mobile.wizard.Messages;
import org.eclipse.dirigible.ide.template.ui.mobile.wizard.MobileTemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.mobile.wizard.MobileTemplateModel;
import org.eclipse.dirigible.ide.template.ui.mobile.wizard.MobileTemplateTargetLocationPage;
import org.eclipse.dirigible.ide.template.ui.mobile.wizard.MobileTemplateTypePage;
import org.eclipse.jface.wizard.IWizardPage;

public class MobileTemplateWizard
extends TemplateWizard {
    private static final String CREATE_MOBILE_APP = Messages.MobileTemplateWizard_CREATE_MOBILE_APP;
    private final MobileTemplateModel model;
    private final MobileTemplateTypePage typesPage;
    private final MobileTemplateTargetLocationPage targetLocationPage;

    public MobileTemplateWizard(IResource resource) {
        this.setWindowTitle(CREATE_MOBILE_APP);
        this.model = new MobileTemplateModel();
        this.model.setSourceResource(resource);
        this.typesPage = new MobileTemplateTypePage(this.model);
        this.targetLocationPage = new MobileTemplateTargetLocationPage(this.model);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.typesPage);
        this.addPage((IWizardPage)this.targetLocationPage);
    }

    public TemplateGenerator getTemplateGenerator() {
        return new MobileTemplateGenerator(this.model);
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (result) {
            StatusLineManagerUtil.setInfoMessage((String)String.format(StatusLineManagerUtil.ARTIFACT_HAS_BEEN_CREATED, this.model.getFileName()));
        }
        return result;
    }
}

