/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.java;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.java.dynamic.compilation.ClassFileManager;
import org.eclipse.dirigible.runtime.java.dynamic.compilation.InMemoryCompilationException;
import org.eclipse.dirigible.runtime.java.dynamic.compilation.InMemoryDiagnosticListener;
import org.eclipse.dirigible.runtime.scripting.AbstractScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.Module;

public class JavaExecutor
extends AbstractScriptExecutor {
    private static final Logger logger = Logger.getLogger(JavaExecutor.class);
    private static final String JAVA_EXTENSION = ".java";
    private static final String CLASSPATH = "-classpath";
    public static final String JAVA_TOOLS_COMPILER = "JAVA_TOOLS_COMPILER";
    private IRepository repository;
    private String[] rootPaths;
    private Map<String, Object> defaultVariables;
    private String classpath;

    public JavaExecutor(IRepository repository, String classpath, String ... rootPaths) {
        this.repository = repository;
        this.rootPaths = rootPaths;
        this.defaultVariables = new HashMap<String, Object>();
        this.classpath = classpath;
    }

    public Object executeServiceModule(HttpServletRequest request, HttpServletResponse response, Object input, String module, Map<Object, Object> executionContext) throws InMemoryCompilationException {
        try {
            this.registerDefaultVariables(request, response, input, null, this.repository, null);
            ClassFileManager fileManager = this.compile(request, module);
            return this.execute(request, response, module, fileManager);
        }
        catch (Throwable t) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            logger.error(t.getMessage(), t);
            throw new InMemoryCompilationException(baos.toString());
        }
    }

    private ClassFileManager compile(HttpServletRequest request, String module) throws IOException, ClassNotFoundException, URISyntaxException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new InMemoryCompilationException("Use JDK instead of JRE");
        }
        InMemoryDiagnosticListener diagnosticListener = new InMemoryDiagnosticListener();
        ClassFileManager fileManager = new ClassFileManager(compiler.getStandardFileManager(diagnosticListener, null, null));
        Module entryModule = this.retrieveModule(this.repository, module, null, this.rootPaths);
        List<JavaFileObject> sourceFiles = fileManager.getSourceFiles(this.retrieveModulesByExtension(this.repository, JAVA_EXTENSION, this.rootPaths), entryModule);
        JavaCompiler.CompilationTask compilationTask = compiler.getTask(null, fileManager, diagnosticListener, Arrays.asList(CLASSPATH, this.getClasspath()), null, sourceFiles);
        Boolean compilationTaskResult = compilationTask.call();
        if (compilationTaskResult == null || !compilationTaskResult.booleanValue()) {
            throw new InMemoryCompilationException(diagnosticListener);
        }
        return fileManager;
    }

    public String getClasspath() {
        return this.classpath;
    }

    private Object execute(HttpServletRequest request, HttpServletResponse response, String module, ClassFileManager fileManager) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Method serviceMethod;
        Class<?> loadedClass = fileManager.getClassLoader(null).loadClass(ClassFileManager.getFQN(module));
        Class[] inputParameters = new Class[]{HttpServletRequest.class, HttpServletResponse.class, Map.class};
        try {
            serviceMethod = loadedClass.getMethod("service", inputParameters);
        }
        catch (Exception exception) {
            return String.format("Requested Java file %s does not have 'public void service(HttpServletRequest request, HttpServletResponse response, Map<String, Object> scope) throws Exception' method", loadedClass.getCanonicalName());
        }
        return serviceMethod.invoke(loadedClass.newInstance(), request, response, this.defaultVariables);
    }

    protected void registerDefaultVariable(Object scope, String name, Object value) {
        this.defaultVariables.put(name, value);
    }

    protected String getModuleType(String path) {
        return "ScriptingServices";
    }
}

