/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.tck.arquillian;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class ArchiveClassLoader
extends URLClassLoader {
    private static final String WEB_ARCHIVE_PREFIX = "WEB-INF/classes/";
    private static final String EMPTY_PREFIX = "";
    private final Archive<?> archive;
    private final String archivePrefix;

    public ArchiveClassLoader(ClassLoader classLoader, Archive<?> archive) {
        super(new URL[0], classLoader);
        this.archive = archive;
        this.archivePrefix = archive instanceof WebArchive ? WEB_ARCHIVE_PREFIX : EMPTY_PREFIX;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.archive.get(this.archivePrefix + name) != null) {
            return this.loadFromArchive(this.archivePrefix + name);
        }
        return super.getResourceAsStream(name);
    }

    @Override
    public URL getResource(String name) {
        if (this.archive.get(this.archivePrefix + name) != null) {
            try {
                return new URL(null, "archive:" + this.archive.getName() + "/" + name, new ArchiveURLStreamHandler());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Could not create URL for archive: " + this.archive.getName() + " and resource " + name, e);
            }
        }
        return super.getResource(name);
    }

    private InputStream loadFromArchive(String name) {
        InputStream in;
        Asset asset = this.archive.get(name).getAsset();
        if (asset instanceof FileAsset) {
            in = asset.openStream();
        } else if (asset instanceof ByteArrayAsset) {
            in = asset.openStream();
        } else {
            throw new RuntimeException("Unsupported asset type " + asset.toString());
        }
        return in;
    }

    private class ArchiveURLStreamHandler
    extends URLStreamHandler {
        private ArchiveURLStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(final URL u) throws IOException {
            return new URLConnection(this, u){
                final /* synthetic */ ArchiveURLStreamHandler this$1;
                {
                    this.this$1 = this$1;
                    super(arg0);
                }

                @Override
                public void connect() throws IOException {
                }

                @Override
                public InputStream getInputStream() throws IOException {
                    String path = this.convertToArchivePath(u);
                    Node node = this.this$1.ArchiveClassLoader.this.archive.get(path);
                    if (node == null) {
                        throw new FileNotFoundException("Requested path: " + path + " does not exist in " + this.this$1.ArchiveClassLoader.this.archive.toString());
                    }
                    Asset asset = node.getAsset();
                    if (asset == null) {
                        return null;
                    }
                    return asset.openStream();
                }

                private String convertToArchivePath(URL url) {
                    String path = url.getPath();
                    return path.replace(this.this$1.ArchiveClassLoader.this.archive.getName() + "/", this.this$1.ArchiveClassLoader.this.archivePrefix);
                }
            };
        }
    }
}

