/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.hk2;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.cdi.hk2.CDIScope;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;

public class CDIHK2Descriptor<T>
extends AbstractActiveDescriptor<T> {
    private transient BeanManager manager;
    private transient Bean<T> bean;
    private transient Type requiredType;

    public CDIHK2Descriptor() {
    }

    private static Set<Annotation> fixQualifiers(Bean<?> bean) {
        Set beanQualifiers = bean.getQualifiers();
        HashSet<Annotation> retVal = new HashSet<Annotation>();
        for (Annotation beanQualifier : beanQualifiers) {
            if (Any.class.equals(beanQualifier.annotationType()) || Default.class.equals(beanQualifier.annotationType())) continue;
            retVal.add(beanQualifier);
        }
        return retVal;
    }

    private static Class<? extends Annotation> fixScope(Bean<?> bean) {
        if (bean.getScope() == null || Dependent.class.equals((Object)bean.getScope())) {
            return PerLookup.class;
        }
        if (Singleton.class.equals((Object)bean.getScope())) {
            return Singleton.class;
        }
        return CDIScope.class;
    }

    public CDIHK2Descriptor(BeanManager manager, Bean<T> bean, Type requiredType) {
        super(bean.getTypes(), CDIHK2Descriptor.fixScope(bean), bean.getName(), CDIHK2Descriptor.fixQualifiers(bean), DescriptorType.CLASS, DescriptorVisibility.NORMAL, 0, null, null, null, new HashMap());
        this.manager = manager;
        this.bean = bean;
        this.requiredType = requiredType;
    }

    public String getImplementation() {
        return this.bean.getBeanClass().getName();
    }

    public Type getImplementationType() {
        return this.bean.getBeanClass().getGenericSuperclass();
    }

    public Class<?> getImplementationClass() {
        return this.bean.getBeanClass();
    }

    public T create(ServiceHandle<?> root) {
        return (T)this.manager.getReference(this.bean, this.requiredType, this.manager.createCreationalContext(this.bean));
    }
}

