/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import jakarta.inject.Inject;
import java.io.File;
import java.util.HashMap;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="create-node-config")
@I18n(value="create.node.config")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Nodes.class, opType=RestEndpoint.OpType.POST, path="create-node-config", description="Create Node Config")})
public class CreateNodeConfigCommand
implements AdminCommand {
    @Inject
    private CommandRunner cr;
    @Param(name="name", primary=true)
    String name;
    @Param(name="nodedir", optional=true)
    String nodedir;
    @Param(name="nodehost", optional=true)
    String nodehost;
    @Param(name="installdir", optional=true)
    String installdir;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (StringUtils.ok((String)this.nodehost) && NetUtils.isThisHostLocal((String)this.nodehost) && StringUtils.ok((String)this.installdir)) {
            TokenResolver resolver = null;
            HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
            resolver = new TokenResolver(systemPropsMap);
            String resolvedInstallDir = resolver.resolve(this.installdir);
            File actualInstallDir = new File(resolvedInstallDir + "/glassfish/modules/admin-cli.jar");
            if (!actualInstallDir.exists()) {
                report.setMessage(Strings.get("invalid.installdir", this.installdir));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_create-node", report, context.getSubject());
        ParameterMap map = new ParameterMap();
        map.add((Object)"DEFAULT", (Object)this.name);
        if (StringUtils.ok((String)this.nodedir)) {
            map.add((Object)"nodedir", (Object)this.nodedir);
        }
        if (StringUtils.ok((String)this.installdir)) {
            map.add((Object)"installdir", (Object)this.installdir);
        }
        if (StringUtils.ok((String)this.nodehost)) {
            map.add((Object)"nodehost", (Object)this.nodehost);
        }
        map.add((Object)"type", (Object)"CONFIG");
        ci.parameters(map);
        ci.execute();
        NodeUtils.sanitizeReport(report);
    }
}

