/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.codehaus.jettison.json.JSONException;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.resources.CommandResult;
import org.glassfish.admin.rest.resources.TemplateExecCommand;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;

@Produces(value={"text/html", "application/json;qs=0.5", "application/xml;qs=0.5"})
public class TemplateCommandPostResource
extends TemplateExecCommand {
    public TemplateCommandPostResource(String resourceName, String commandName, String commandMethod, String commandAction, String commandDisplayName, boolean isLinkedToParent) {
        super(resourceName, commandName, commandMethod, commandAction, commandDisplayName, isLinkedToParent);
    }

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public Response processPostLegacyFormat(ParameterMap data) {
        if (data == null) {
            data = new ParameterMap();
        }
        if (data.containsKey((Object)"error")) {
            String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
            throw new WebApplicationException(ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo));
        }
        return super.executeCommandLegacyFormat(this.preprocessData(data));
    }

    @POST
    @Consumes(value={"application/vnd.oracle.glassfish+json"})
    @Produces(value={"application/vnd.oracle.glassfish+json;qs=0.5"})
    public CommandResult processPost(ParameterMap data) {
        if (data == null) {
            data = new ParameterMap();
        }
        if (data.containsKey((Object)"error")) {
            String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
            throw new WebApplicationException(ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo));
        }
        return super.executeCommand(this.preprocessData(data));
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response post(FormDataMultiPart formData) {
        return this.processPostLegacyFormat(TemplateCommandPostResource.createDataBasedOnForm(formData));
    }

    @POST
    public Response processPost() {
        try {
            return this.processPostLegacyFormat(new ParameterMap());
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    @Produces(value={"text/event-stream;qs=0.5"})
    public Response processSsePost(ParameterMap data) {
        if (data == null) {
            data = new ParameterMap();
        }
        if (data.containsKey((Object)"error")) {
            String errorMessage = localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax.");
            throw new WebApplicationException(ResourceUtil.getResponse(400, errorMessage, this.requestHeaders, this.uriInfo));
        }
        return super.executeCommandAsSse(this.preprocessData(data));
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/event-stream;qs=0.5"})
    public Response ssePost(FormDataMultiPart formData) {
        return this.processSsePost(TemplateCommandPostResource.createDataBasedOnForm(formData));
    }

    @POST
    @Produces(value={"text/event-stream;qs=0.5"})
    public Response processSsePost() {
        try {
            return this.processSsePost(new ParameterMap());
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    public ActionReportResult getLegacyFormat() {
        return this.optionsLegacyFormat();
    }

    @GET
    @Produces(value={"application/vnd.oracle.glassfish+json;qs=0.5"})
    public String get() {
        try {
            return this.options();
        }
        catch (JSONException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private ParameterMap preprocessData(ParameterMap data) {
        this.processCommandParams(data);
        this.adjustParameters(data);
        this.purgeEmptyEntries(data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParameterMap createDataBasedOnForm(FormDataMultiPart formData) {
        ParameterMap data = new ParameterMap();
        if (formData == null) {
            formData = new FormDataMultiPart();
        }
        try {
            Map m1 = formData.getFields();
            Set ss = m1.keySet();
            for (String fieldName : ss) {
                for (FormDataBodyPart bodyPart : formData.getFields(fieldName)) {
                    if (bodyPart.getContentDisposition().getFileName() == null) {
                        data.add((Object)fieldName, (Object)bodyPart.getValue());
                        continue;
                    }
                    InputStream fileStream = (InputStream)bodyPart.getValueAs(InputStream.class);
                    String fileName = bodyPart.getContentDisposition().getFileName();
                    if (fileName.contains("/")) {
                        fileName = Util.getName(fileName, '/');
                    } else if (fileName.contains("\\")) {
                        fileName = Util.getName(fileName, '\\');
                    }
                    File f = Util.saveTemporaryFile(fileName, fileStream);
                    data.add((Object)fieldName, (Object)f.getAbsolutePath());
                }
            }
        }
        catch (Exception ex) {
            RestLogging.restLogger.log(Level.SEVERE, null, ex);
        }
        finally {
            formData.cleanup();
        }
        return data;
    }
}

