/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.glassfish.javaee.full.deployment.EarLibClassLoader;
import org.glassfish.web.loader.WebappClassLoader;
import org.jboss.weld.bootstrap.api.Singleton;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.bootstrap.api.helpers.TCCLSingletonProvider;

public class ACLSingletonProvider
extends SingletonProvider {
    private static final System.Logger LOG = System.getLogger(ACLSingletonProvider.class.getName());

    public static void initializeSingletonProvider() {
        boolean earSupport;
        try {
            Class.forName("org.glassfish.javaee.full.deployment.EarClassLoader");
            earSupport = true;
        }
        catch (ClassNotFoundException ignore) {
            earSupport = false;
        }
        ACLSingletonProvider provider = earSupport ? new ACLSingletonProvider() : new TCCLSingletonProvider();
        SingletonProvider.initialize((SingletonProvider)provider);
        LOG.log(System.Logger.Level.DEBUG, () -> "SingletonProvider initialized: " + String.valueOf(provider));
    }

    public <T> ACLSingleton<T> create(Class<? extends T> expectedType) {
        return new ACLSingleton();
    }

    private static class ACLSingleton<T>
    implements Singleton<T> {
        private static final System.Logger LOG = System.getLogger(ACLSingleton.class.getName());
        private final Map<ClassLoader, T> store = new ConcurrentHashMap<ClassLoader, T>();
        private final ClassLoader commonClassLoader = ((ClassLoaderHierarchy)Globals.get(ClassLoaderHierarchy.class)).getCommonClassLoader();
        private static ClassLoader bootstrapCL = Object.class.getClassLoader();

        private ACLSingleton() {
        }

        public T get(String id) {
            ClassLoader appClassLoader = this.getClassLoader();
            Object instance = this.store.get(appClassLoader);
            if (instance == null) {
                throw new IllegalStateException("Singleton not set for " + String.valueOf(appClassLoader));
            }
            LOG.log(System.Logger.Level.DEBUG, () -> "get(" + id + ") - found " + String.valueOf(instance) + ";  we use ear/war classloader instead of id.");
            return instance;
        }

        public boolean isSet(String id) {
            return this.store.containsKey(this.getClassLoader());
        }

        public void set(String id, T object) {
            LOG.log(System.Logger.Level.DEBUG, () -> "set(id=" + id + ", object=" + String.valueOf(object) + "); we use ear/war classloader instead of id.");
            this.store.put(this.getClassLoader(), object);
        }

        public void clear(String id) {
            LOG.log(System.Logger.Level.DEBUG, () -> "clear(id=" + id + "); we use ear/war classloader instead of id.");
            this.store.remove(this.getClassLoader());
        }

        private ClassLoader getClassLoader() {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader == null) {
                throw new RuntimeException("Thread's context class loader is null");
            }
            ClassLoader classLoader = contextClassLoader;
            ClassLoader appClassLoader = contextClassLoader;
            while (classLoader != this.commonClassLoader && classLoader != bootstrapCL) {
                if (classLoader instanceof EarLibClassLoader) {
                    return classLoader;
                }
                if (classLoader instanceof WebappClassLoader) {
                    appClassLoader = classLoader;
                }
                classLoader = this.getParent(classLoader);
            }
            return appClassLoader;
        }

        private ClassLoader getParent(ClassLoader classLoader) {
            LOG.log(System.Logger.Level.TRACE, () -> "getParent(classLoader=" + String.valueOf(classLoader) + ")");
            return classLoader.getParent();
        }
    }
}

