/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.tree.BinaryArithmeticExpression;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.DoubleExpression;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.FloatExpression;
import org.glassfish.rmic.tools.tree.IntExpression;
import org.glassfish.rmic.tools.tree.LongExpression;
import org.glassfish.rmic.tools.tree.NegativeExpression;

public class SubtractExpression
extends BinaryArithmeticExpression {
    public SubtractExpression(long where, Expression left, Expression right) {
        super(30, where, left, right);
    }

    @Override
    Expression eval(int a, int b) {
        return new IntExpression(this.where, a - b);
    }

    @Override
    Expression eval(long a, long b) {
        return new LongExpression(this.where, a - b);
    }

    @Override
    Expression eval(float a, float b) {
        return new FloatExpression(this.where, a - b);
    }

    @Override
    Expression eval(double a, double b) {
        return new DoubleExpression(this.where, a - b);
    }

    @Override
    Expression simplify() {
        if (this.type.inMask(62)) {
            if (this.left.equals(0)) {
                return new NegativeExpression(this.where, this.right);
            }
            if (this.right.equals(0)) {
                return this.left;
            }
        }
        return this;
    }

    @Override
    void codeOperation(Environment env, Context ctx, Assembler asm) {
        asm.add(this.where, 100 + this.type.getTypeCodeOffset());
    }
}

