/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.gmodel.generator;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fx.ide.gmodel.gModelDSL.GDomainElement;
import org.eclipse.fx.ide.gmodel.gModelDSL.GDomainMap;
import org.eclipse.fx.ide.gmodel.gModelDSL.GDomainProperty;
import org.eclipse.fx.ide.gmodel.gModelDSL.GModel;
import org.eclipse.fx.ide.gmodel.generator.Util;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class GsonGenerator
implements IGenerator {
    public void doGenerate(Resource input, IFileSystemAccess fsa) {
        EObject _head = (EObject)IterableExtensions.head((Iterable)input.getContents());
        GModel root = (GModel)_head;
        String _replace = root.getName().replace(".", "/");
        String _plus = _replace + "/gson/GsonBase.java";
        fsa.generateFile(_plus, this.generateBase(root));
        Consumer<GDomainElement> _function = t -> {
            String _replace_1 = root.getName().replace(".", "/");
            String _plus_1 = _replace_1 + "/gson/Gson";
            String _name = t.getName();
            String _plus_2 = _plus_1 + _name;
            String _plus_3 = _plus_2 + "Impl.java";
            fsa.generateFile(_plus_3, this.generateType((GDomainElement)t, root));
        };
        root.getTypeList().forEach(_function);
        String _replace_1 = root.getName().replace(".", "/");
        String _plus_1 = _replace_1 + "/gson/GsonElementFactory.java";
        fsa.generateFile(_plus_1, this.generateDeserializer(root));
    }

    public CharSequence generateBase(GModel m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _name = m.getName();
        _builder.append(_name);
        _builder.append(".gson;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import com.google.gson.JsonArray;");
        _builder.newLine();
        _builder.append("import com.google.gson.JsonElement;");
        _builder.newLine();
        _builder.append("import com.google.gson.JsonObject;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("public interface GsonBase {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public static JsonArray toJsonArray(List<JsonElement> list) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("JsonArray ar = new JsonArray();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("list.stream().forEach(ar::add);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return ar;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public static JsonArray toDomainJsonArray(List<?> list) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("JsonArray ar = new JsonArray();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("list.stream().map( e -> (GsonBase)e ).map(GsonBase::toJSONObject).forEach(ar::add);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return ar;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public JsonObject toJSONObject();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateType(GDomainElement e, GModel m) {
        boolean _notEquals_7;
        boolean _notEquals_6;
        boolean _notEquals_4;
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _name = m.getName();
        _builder.append(_name);
        _builder.append(".gson;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import ");
        String _name_1 = m.getName();
        _builder.append(_name_1);
        _builder.append(".*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import com.google.gson.JsonObject;");
        _builder.newLine();
        _builder.newLine();
        Set<GDomainElement> superHierarchy = Util.collectHierarchicalList(e.getSuperTypeList());
        _builder.newLineIfNotEmpty();
        EList<GDomainProperty> _propertyList = e.getPropertyList();
        HashSet<GDomainProperty> properties = new HashSet<GDomainProperty>((Collection<GDomainProperty>)_propertyList);
        _builder.newLineIfNotEmpty();
        Consumer<GDomainElement> _function = s -> properties.addAll((Collection<GDomainProperty>)s.getPropertyList());
        superHierarchy.forEach(_function);
        _builder.newLineIfNotEmpty();
        _builder.append("public final class Gson");
        String _name_2 = e.getName();
        _builder.append(_name_2);
        _builder.append("Impl implements GsonBase, ");
        String _name_3 = e.getName();
        _builder.append(_name_3);
        boolean _isEmpty = e.getSuperTypeList().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append(", ");
            Functions.Function1 _function_1 = v -> v.getName();
            Functions.Function1 _function_2 = v -> v.getName();
            String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)IterableExtensions.sortBy(superHierarchy, (Functions.Function1)_function_1), (Functions.Function1)_function_2), (CharSequence)", ");
            _builder.append(_join);
        }
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public Gson");
        String _name_4 = e.getName();
        _builder.append(_name_4, "\t");
        _builder.append("Impl(JsonObject jsonObject) {");
        _builder.newLineIfNotEmpty();
        GDomainMap _map = e.getMap();
        boolean bl2 = _notEquals = !Objects.equals(_map, null);
        if (_notEquals) {
            _builder.append("\t\t");
            _builder.append("this.propertyMap = toMap(jsonObject);");
            _builder.newLine();
        } else {
            Functions.Function1 _function_3 = p -> p.getName();
            List _sortBy = IterableExtensions.sortBy(properties, (Functions.Function1)_function_3);
            for (GDomainProperty p2 : _sortBy) {
                _builder.append("\t\t");
                CharSequence _generatePropertyInit = this.generatePropertyInit(p2);
                _builder.append((Object)_generatePropertyInit, "\t\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        GDomainMap _map_1 = e.getMap();
        boolean bl3 = _notEquals_1 = !Objects.equals(_map_1, null);
        if (_notEquals_1) {
            _builder.append("\t");
            _builder.append("public Gson");
            String _name_5 = e.getName();
            _builder.append(_name_5, "\t");
            _builder.append("Impl(java.util.Map<String,");
            String _plainType = GsonGenerator.getPlainType(e.getMap());
            _builder.append(_plainType, "\t");
            _builder.append("> propertyMap) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("this.propertyMap = propertyMap;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        } else {
            _builder.append("\t");
            _builder.append("public Gson");
            String _name_6 = e.getName();
            _builder.append(_name_6, "\t");
            _builder.append("Impl(");
            Functions.Function1 _function_4 = p_1 -> p_1.getName();
            Functions.Function1 _function_5 = p_1 -> {
                String _type = GsonGenerator.getType(p_1);
                String _plus = _type + " ";
                String _name_7 = p_1.getName();
                return _plus + _name_7;
            };
            String _join_1 = IterableExtensions.join((Iterable)ListExtensions.map((List)IterableExtensions.sortBy(properties, (Functions.Function1)_function_4), (Functions.Function1)_function_5), (CharSequence)", ");
            _builder.append(_join_1, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            Functions.Function1 _function_6 = p_1 -> p_1.getName();
            List _sortBy_1 = IterableExtensions.sortBy(properties, (Functions.Function1)_function_6);
            for (GDomainProperty p_12 : _sortBy_1) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("this.");
                String _name_7 = p_12.getName();
                _builder.append(_name_7, "\t\t");
                _builder.append(" = ");
                String _name_8 = p_12.getName();
                _builder.append(_name_8, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public JsonObject toJSONObject() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("JsonObject o = new JsonObject();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("o.addProperty( \"$gtype\", \"");
        String _name_9 = e.getName();
        _builder.append(_name_9, "\t\t");
        _builder.append("\" );");
        _builder.newLineIfNotEmpty();
        GDomainMap _map_2 = e.getMap();
        boolean bl4 = _notEquals_2 = !Objects.equals(_map_2, null);
        if (_notEquals_2) {
            _builder.append("\t\t");
            _builder.append("for( java.util.Map.Entry<String,");
            String _plainType_1 = GsonGenerator.getPlainType(e.getMap());
            _builder.append(_plainType_1, "\t\t");
            _builder.append("> e : this.propertyMap ) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("o.add( e.getKey(), ((GsonBase)e.getValue()).toJSONObject() );");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        } else {
            Functions.Function1 _function_7 = p_2 -> p_2.getName();
            List _sortBy_2 = IterableExtensions.sortBy(properties, (Functions.Function1)_function_7);
            for (GDomainProperty p_22 : _sortBy_2) {
                _builder.append("\t\t");
                CharSequence _generatePropertyToJson = this.generatePropertyToJson(p_22);
                _builder.append((Object)_generatePropertyToJson, "\t\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("\t\t");
        _builder.append("return o;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public String toString() {");
        _builder.newLine();
        GDomainMap _map_3 = e.getMap();
        boolean bl5 = _notEquals_3 = !Objects.equals(_map_3, null);
        if (_notEquals_3) {
            _builder.append("\t\t");
            _builder.append("return getClass().getSimpleName() + \"@\" + Integer.toHexString(hashCode()) + \" { \"");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t\t");
            _builder.append("+ \"propertyMap : \" + propertyMap");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("+\" }\";");
            _builder.newLine();
        } else {
            _builder.append("\t\t");
            _builder.append("return getClass().getSimpleName() + \"@\" + Integer.toHexString(hashCode()) + \" { \"");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t\t");
            Functions.Function1 _function_8 = p_3 -> p_3.getName();
            Functions.Function1 _function_9 = p_3 -> {
                boolean _notEquals_4;
                String _xifexpression = null;
                String _builtIn = p_3.getBuiltIn();
                boolean bl = _notEquals_4 = !Objects.equals(_builtIn, null);
                if (_notEquals_4) {
                    String _name_10 = p_3.getName();
                    String _plus = " + \"" + _name_10;
                    String _plus_1 = _plus + " : \" + ";
                    String _name_11 = p_3.getName();
                    _xifexpression = _plus_1 + _name_11;
                } else {
                    String _xifexpression_1 = null;
                    boolean _isList = p_3.isList();
                    if (_isList) {
                        String _name_12 = p_3.getName();
                        String _plus_2 = " + \"" + _name_12;
                        String _plus_3 = _plus_2 + " : \" + ";
                        String _name_13 = p_3.getName();
                        String _plus_4 = _plus_3 + _name_13;
                        _xifexpression_1 = _plus_4 + ".stream().map( e -> e.getClass().getSimpleName() + \"@\" + Integer.toHexString(e.hashCode()) ).collect(java.util.stream.Collectors.toList())";
                    } else {
                        String _name_14 = p_3.getName();
                        String _plus_5 = " + \"" + _name_14;
                        String _plus_6 = _plus_5 + " : \" + (";
                        String _name_15 = p_3.getName();
                        String _plus_7 = _plus_6 + _name_15;
                        String _plus_8 = _plus_7 + " == null ? null : ";
                        String _name_16 = p_3.getName();
                        String _plus_9 = _plus_8 + _name_16;
                        String _plus_10 = _plus_9 + ".getClass().getSimpleName() + \"@\" + Integer.toHexString(";
                        String _name_17 = p_3.getName();
                        String _plus_11 = _plus_10 + _name_17;
                        _xifexpression_1 = _plus_11 + ".hashCode()))";
                    }
                    _xifexpression = _xifexpression_1;
                }
                return _xifexpression;
            };
            List _map_4 = ListExtensions.map((List)IterableExtensions.sortBy(properties, (Functions.Function1)_function_8), (Functions.Function1)_function_9);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append(" ");
            _builder_1.append("+ \", \"");
            _builder_1.newLine();
            String _join_2 = IterableExtensions.join((Iterable)_map_4, (CharSequence)_builder_1);
            _builder.append(_join_2, "\t\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t\t\t");
            _builder.append("+\" }\";");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        GDomainMap _map_5 = e.getMap();
        boolean bl6 = _notEquals_4 = !Objects.equals(_map_5, null);
        if (_notEquals_4) {
            boolean _notEquals_5;
            _builder.append("\t");
            _builder.append("private static java.util.Map<String,");
            String _plainType_2 = GsonGenerator.getPlainType(e.getMap());
            _builder.append(_plainType_2, "\t");
            _builder.append("> toMap(JsonObject o) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("java.util.Map<String,");
            String _plainType_3 = GsonGenerator.getPlainType(e.getMap());
            _builder.append(_plainType_3, "\t\t");
            _builder.append("> rv = new java.util.HashMap<>();");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("for( java.util.Map.Entry<String,com.google.gson.JsonElement> e : o.entrySet() ) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("if( e.getKey().startsWith(\"$\") ) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.append("continue;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            GDomainElement _ref = e.getMap().getRef();
            boolean bl7 = _notEquals_5 = !Objects.equals(_ref, null);
            if (_notEquals_5) {
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("rv.put( e.getKey(), GsonElementFactory.create");
                String _name_10 = e.getMap().getRef().getName();
                _builder.append(_name_10, "\t\t\t");
                _builder.append("(e.getValue().getAsJsonObject()) );");
                _builder.newLineIfNotEmpty();
            } else {
                String _plainType_4 = GsonGenerator.getPlainType(e.getMap());
                boolean _equals = Objects.equals(_plainType_4, "boolean");
                if (_equals) {
                    _builder.append("\t");
                    _builder.append("\t\t");
                    _builder.append("rv.put( e.getKey(), e.getValue().getAsBoolean() );");
                    _builder.newLine();
                } else {
                    String _plainType_5 = GsonGenerator.getPlainType(e.getMap());
                    boolean _equals_1 = Objects.equals(_plainType_5, "int");
                    if (_equals_1) {
                        _builder.append("\t");
                        _builder.append("\t\t");
                        _builder.append("rv.put( e.getKey(), e.getValue().getAsInt() );");
                        _builder.newLine();
                    } else {
                        String _plainType_6 = GsonGenerator.getPlainType(e.getMap());
                        boolean _equals_2 = Objects.equals(_plainType_6, "double");
                        if (_equals_2) {
                            _builder.append("\t");
                            _builder.append("\t\t");
                            _builder.append("rv.put( e.getKey(), e.getValue().getAsDouble() );");
                            _builder.newLine();
                        } else {
                            String _plainType_7 = GsonGenerator.getPlainType(e.getMap());
                            boolean _equals_3 = Objects.equals(_plainType_7, "String");
                            if (_equals_3) {
                                _builder.append("\t");
                                _builder.append("\t\t");
                                _builder.append("rv.put( e.getKey(), e.getValue().getAsString() );");
                                _builder.newLine();
                            }
                        }
                    }
                }
            }
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return rv;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t");
            _builder.append("private java.util.Map<String,");
            String _plainType_8 = GsonGenerator.getPlainType(e.getMap());
            _builder.append(_plainType_8, "\t");
            _builder.append("> propertyMap;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("public java.util.Map<String,");
            String _plainType_9 = GsonGenerator.getPlainType(e.getMap());
            _builder.append(_plainType_9, "\t");
            _builder.append("> getPropertyMap() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return this.propertyMap;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        } else {
            Functions.Function1 _function_10 = p_3 -> p_3.getName();
            List _sortBy_3 = IterableExtensions.sortBy(properties, (Functions.Function1)_function_10);
            for (GDomainProperty p_32 : _sortBy_3) {
                _builder.append("\t");
                CharSequence _generatePropertyEntry = this.generatePropertyEntry(p_32);
                _builder.append((Object)_generatePropertyEntry, "\t");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
            }
        }
        _builder.newLine();
        _builder.append("\t");
        String _lastSegment = m.eResource().getURI().lastSegment();
        int _length = m.eResource().getURI().lastSegment().length();
        int _minus = _length - 5;
        String name = _lastSegment.substring(0, _minus);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public static class Builder implements ");
        String _name_11 = e.getName();
        _builder.append(_name_11, "\t");
        _builder.append(".Builder {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("private final ");
        _builder.append(name, "\t\t");
        _builder.append("GModel instance;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public Builder(");
        _builder.append(name, "\t\t");
        _builder.append("GModel instance) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.append("this.instance = instance;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        GDomainMap _map_6 = e.getMap();
        boolean bl8 = _notEquals_6 = !Objects.equals(_map_6, null);
        if (_notEquals_6) {
            _builder.append("\t\t");
            _builder.append("java.util.Map<String,");
            String _plainType_10 = GsonGenerator.getPlainType(e.getMap());
            _builder.append(_plainType_10, "\t\t");
            _builder.append("> propertyMap = new java.util.HashMap<>();");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("public Builder propertyMap(java.util.Map<String,");
            String _plainType_11 = GsonGenerator.getPlainType(e.getMap());
            _builder.append(_plainType_11, "\t\t");
            _builder.append("> propertyMap) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("this.propertyMap.putAll(propertyMap);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("return this;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("public Builder propertyMap(String key, ");
            String _plainType_12 = GsonGenerator.getPlainType(e.getMap());
            _builder.append(_plainType_12, "\t\t");
            _builder.append(" value) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("this.propertyMap.put(key,value);");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("return this;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("public Builder propertyMap(String key, java.util.function.Function<");
            String _plainType_13 = GsonGenerator.getPlainType(e.getMap());
            _builder.append(_plainType_13, "\t\t");
            _builder.append(".Builder,");
            String _plainType_14 = GsonGenerator.getPlainType(e.getMap());
            _builder.append(_plainType_14, "\t\t");
            _builder.append("> provider) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("this.propertyMap.put(key,provider.apply( new Gson");
            String _plainType_15 = GsonGenerator.getPlainType(e.getMap());
            _builder.append(_plainType_15, "\t\t\t");
            _builder.append("Impl.Builder(instance) ) );");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("return this;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("public Builder propertyMap(java.util.function.Function<");
            _builder.append(name, "\t\t");
            _builder.append("GModel,java.util.Map<String,");
            String _plainType_16 = GsonGenerator.getPlainType(e.getMap());
            _builder.append(_plainType_16, "\t\t");
            _builder.append(">> provider) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("this.propertyMap.putAll(provider.apply( instance ) );");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("return this;");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
        } else {
            Functions.Function1 _function_11 = p_4 -> p_4.getName();
            List _sortBy_4 = IterableExtensions.sortBy(properties, (Functions.Function1)_function_11);
            for (GDomainProperty p_42 : _sortBy_4) {
                boolean _isList = p_42.isList();
                if (_isList) {
                    _builder.append("\t\t");
                    _builder.append("private final ");
                    String _type = GsonGenerator.getType(p_42);
                    _builder.append(_type, "\t\t");
                    _builder.append(" ");
                    String _name_12 = p_42.getName();
                    _builder.append(_name_12, "\t\t");
                    _builder.append(" = new java.util.ArrayList<>();");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("public Builder ");
                    String _name_13 = p_42.getName();
                    _builder.append(_name_13, "\t\t");
                    _builder.append("(");
                    String _type_1 = GsonGenerator.getType(p_42);
                    _builder.append(_type_1, "\t\t");
                    _builder.append(" ");
                    String _name_14 = p_42.getName();
                    _builder.append(_name_14, "\t\t");
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("this.");
                    String _name_15 = p_42.getName();
                    _builder.append(_name_15, "\t\t\t");
                    _builder.append(".addAll(");
                    String _name_16 = p_42.getName();
                    _builder.append(_name_16, "\t\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("return this;");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("public Builder append");
                    String _firstUpper = StringExtensions.toFirstUpper((String)p_42.getName());
                    _builder.append(_firstUpper, "\t\t");
                    _builder.append("(");
                    String _plainType_17 = GsonGenerator.getPlainType(p_42);
                    _builder.append(_plainType_17, "\t\t");
                    _builder.append(" ");
                    String _name_17 = p_42.getName();
                    _builder.append(_name_17, "\t\t");
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("this.");
                    String _name_18 = p_42.getName();
                    _builder.append(_name_18, "\t\t\t");
                    _builder.append(".add(");
                    String _name_19 = p_42.getName();
                    _builder.append(_name_19, "\t\t\t");
                    _builder.append(");");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("return this;");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                    String _builtIn = p_42.getBuiltIn();
                    boolean _equals_4 = Objects.equals(_builtIn, null);
                    if (!_equals_4) continue;
                    _builder.append("\t\t");
                    _builder.append("public Builder ");
                    String _name_20 = p_42.getName();
                    _builder.append(_name_20, "\t\t");
                    _builder.append("(java.util.function.Function<");
                    _builder.append(name, "\t\t");
                    _builder.append("GModel,java.util.List<");
                    String _plainType_18 = GsonGenerator.getPlainType(p_42);
                    _builder.append(_plainType_18, "\t\t");
                    _builder.append(">> provider) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    String _name_21 = p_42.getName();
                    _builder.append(_name_21, "\t\t\t");
                    _builder.append("( provider.apply( instance ) );");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("return this;");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("public Builder append");
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)p_42.getName());
                    _builder.append(_firstUpper_1, "\t\t");
                    _builder.append("(java.util.function.Function<");
                    String _plainType_19 = GsonGenerator.getPlainType(p_42);
                    _builder.append(_plainType_19, "\t\t");
                    _builder.append(".Builder,");
                    String _plainType_20 = GsonGenerator.getPlainType(p_42);
                    _builder.append(_plainType_20, "\t\t");
                    _builder.append("> provider) {");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("append");
                    String _firstUpper_2 = StringExtensions.toFirstUpper((String)p_42.getName());
                    _builder.append(_firstUpper_2, "\t\t\t");
                    _builder.append("( provider.apply( new Gson");
                    String _plainType_21 = GsonGenerator.getPlainType(p_42);
                    _builder.append(_plainType_21, "\t\t\t");
                    _builder.append("Impl.Builder(instance) ) );");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("return this;");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                    continue;
                }
                _builder.append("\t\t");
                _builder.append("private ");
                String _type_2 = GsonGenerator.getType(p_42);
                _builder.append(_type_2, "\t\t");
                _builder.append(" ");
                String _name_22 = p_42.getName();
                _builder.append(_name_22, "\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("public Builder ");
                String _name_23 = p_42.getName();
                _builder.append(_name_23, "\t\t");
                _builder.append("(");
                String _type_3 = GsonGenerator.getType(p_42);
                _builder.append(_type_3, "\t\t");
                _builder.append(" ");
                String _name_24 = p_42.getName();
                _builder.append(_name_24, "\t\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("this.");
                String _name_25 = p_42.getName();
                _builder.append(_name_25, "\t\t\t");
                _builder.append(" = ");
                String _name_26 = p_42.getName();
                _builder.append(_name_26, "\t\t\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("return this;");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
            }
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("public ");
        String _name_27 = e.getName();
        _builder.append(_name_27, "\t\t");
        _builder.append(" build() {");
        _builder.newLineIfNotEmpty();
        GDomainMap _map_7 = e.getMap();
        boolean bl9 = _notEquals_7 = !Objects.equals(_map_7, null);
        if (_notEquals_7) {
            _builder.append("\t\t\t");
            _builder.append("return new Gson");
            String _name_28 = e.getName();
            _builder.append(_name_28, "\t\t\t");
            _builder.append("Impl(propertyMap);");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t\t\t");
            _builder.append("return new Gson");
            String _name_29 = e.getName();
            _builder.append(_name_29, "\t\t\t");
            _builder.append("Impl(");
            Functions.Function1 _function_12 = p_5 -> p_5.getName();
            Functions.Function1 _function_13 = p_5 -> p_5.getName();
            String _join_3 = IterableExtensions.join((Iterable)ListExtensions.map((List)IterableExtensions.sortBy(properties, (Functions.Function1)_function_12), (Functions.Function1)_function_13), (CharSequence)", ");
            _builder.append(_join_3, "\t\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePropertyToJson(GDomainProperty p) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isList = p.isList();
        if (_isList) {
            String _plainType = GsonGenerator.getPlainType(p);
            boolean _equals = Objects.equals(_plainType, "boolean");
            if (_equals) {
                _builder.append("o.add( \"");
                String _name = p.getName();
                _builder.append(_name);
                _builder.append("\", GsonBase.toJsonArray(get");
                String _firstUpper = StringExtensions.toFirstUpper((String)p.getName());
                _builder.append(_firstUpper);
                _builder.append("().stream().map(com.google.gson.JsonPrimitive::new).collect(java.util.stream.Collectors.toList())) );");
                _builder.newLineIfNotEmpty();
            } else {
                String _plainType_1 = GsonGenerator.getPlainType(p);
                boolean _equals_1 = Objects.equals(_plainType_1, "int");
                if (_equals_1) {
                    _builder.append("o.add( \"");
                    String _name_1 = p.getName();
                    _builder.append(_name_1);
                    _builder.append("\", GsonBase.toJsonArray(get");
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)p.getName());
                    _builder.append(_firstUpper_1);
                    _builder.append("().stream().map(com.google.gson.JsonPrimitive::new).collect(java.util.stream.Collectors.toList())) );");
                    _builder.newLineIfNotEmpty();
                } else {
                    String _plainType_2 = GsonGenerator.getPlainType(p);
                    boolean _equals_2 = Objects.equals(_plainType_2, "double");
                    if (_equals_2) {
                        _builder.append("o.add( \"");
                        String _name_2 = p.getName();
                        _builder.append(_name_2);
                        _builder.append("\", GsonBase.toJsonArray(get");
                        String _firstUpper_2 = StringExtensions.toFirstUpper((String)p.getName());
                        _builder.append(_firstUpper_2);
                        _builder.append("().stream().map(com.google.gson.JsonPrimitive::new).collect(java.util.stream.Collectors.toList())) );");
                        _builder.newLineIfNotEmpty();
                    } else {
                        String _plainType_3 = GsonGenerator.getPlainType(p);
                        boolean _equals_3 = Objects.equals(_plainType_3, "String");
                        if (_equals_3) {
                            _builder.append("o.add( \"");
                            String _name_3 = p.getName();
                            _builder.append(_name_3);
                            _builder.append("\", GsonBase.toJsonArray(get");
                            String _firstUpper_3 = StringExtensions.toFirstUpper((String)p.getName());
                            _builder.append(_firstUpper_3);
                            _builder.append("().stream().map(com.google.gson.JsonPrimitive::new).collect(java.util.stream.Collectors.toList())) );");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append("o.add( \"");
                            String _name_4 = p.getName();
                            _builder.append(_name_4);
                            _builder.append("\", GsonBase.toDomainJsonArray(get");
                            String _firstUpper_4 = StringExtensions.toFirstUpper((String)p.getName());
                            _builder.append(_firstUpper_4);
                            _builder.append("()) );");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                }
            }
        } else {
            String _type = GsonGenerator.getType(p);
            boolean _equals_4 = Objects.equals(_type, "boolean");
            if (_equals_4) {
                _builder.append("o.addProperty( \"");
                String _name_5 = p.getName();
                _builder.append(_name_5);
                _builder.append("\", is");
                String _firstUpper_5 = StringExtensions.toFirstUpper((String)p.getName());
                _builder.append(_firstUpper_5);
                _builder.append("() );");
                _builder.newLineIfNotEmpty();
            } else {
                String _type_1 = GsonGenerator.getType(p);
                boolean _equals_5 = Objects.equals(_type_1, "int");
                if (_equals_5) {
                    _builder.append("o.addProperty( \"");
                    String _name_6 = p.getName();
                    _builder.append(_name_6);
                    _builder.append("\", get");
                    String _firstUpper_6 = StringExtensions.toFirstUpper((String)p.getName());
                    _builder.append(_firstUpper_6);
                    _builder.append("() );");
                    _builder.newLineIfNotEmpty();
                } else {
                    String _type_2 = GsonGenerator.getType(p);
                    boolean _equals_6 = Objects.equals(_type_2, "double");
                    if (_equals_6) {
                        _builder.append("o.addProperty( \"");
                        String _name_7 = p.getName();
                        _builder.append(_name_7);
                        _builder.append("\", get");
                        String _firstUpper_7 = StringExtensions.toFirstUpper((String)p.getName());
                        _builder.append(_firstUpper_7);
                        _builder.append("() );");
                        _builder.newLineIfNotEmpty();
                    } else {
                        String _type_3 = GsonGenerator.getType(p);
                        boolean _equals_7 = Objects.equals(_type_3, "String");
                        if (_equals_7) {
                            _builder.append("o.addProperty( \"");
                            String _name_8 = p.getName();
                            _builder.append(_name_8);
                            _builder.append("\", get");
                            String _firstUpper_8 = StringExtensions.toFirstUpper((String)p.getName());
                            _builder.append(_firstUpper_8);
                            _builder.append("() );");
                            _builder.newLineIfNotEmpty();
                        } else {
                            _builder.append("o.add( \"");
                            String _name_9 = p.getName();
                            _builder.append(_name_9);
                            _builder.append("\", get");
                            String _firstUpper_9 = StringExtensions.toFirstUpper((String)p.getName());
                            _builder.append(_firstUpper_9);
                            _builder.append("() == null ? null : ((GsonBase)get");
                            String _firstUpper_10 = StringExtensions.toFirstUpper((String)p.getName());
                            _builder.append(_firstUpper_10);
                            _builder.append("()).toJSONObject() );");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                }
            }
        }
        return _builder;
    }

    public CharSequence generatePropertyInit(GDomainProperty p) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isList = p.isList();
        if (_isList) {
            String _plainType = GsonGenerator.getPlainType(p);
            boolean _equals = Objects.equals(_plainType, "boolean");
            if (_equals) {
                _builder.append("this.");
                String _name = p.getName();
                _builder.append(_name);
                _builder.append(" = jsonObject.has(\"");
                String _name_1 = p.getName();
                _builder.append(_name_1);
                _builder.append("\") ? java.util.Collections.unmodifiableList(java.util.stream.StreamSupport.stream( jsonObject.getAsJsonArray(\"");
                String _name_2 = p.getName();
                _builder.append(_name_2);
                _builder.append("\").spliterator(), false )");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t\t\t\t");
                _builder.append(".map( e -> e.getAsBoolean()).collect(java.util.stream.Collectors.toList())) : java.util.Collections.emptyList();");
                _builder.newLine();
            } else {
                String _plainType_1 = GsonGenerator.getPlainType(p);
                boolean _equals_1 = Objects.equals(_plainType_1, "int");
                if (_equals_1) {
                    _builder.append("this.");
                    String _name_3 = p.getName();
                    _builder.append(_name_3);
                    _builder.append(" = jsonObject.has(\"");
                    String _name_4 = p.getName();
                    _builder.append(_name_4);
                    _builder.append("\") ? java.util.Collections.unmodifiableList(java.util.stream.StreamSupport.stream( jsonObject.getAsJsonArray(\"");
                    String _name_5 = p.getName();
                    _builder.append(_name_5);
                    _builder.append("\").spliterator(), false )");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t\t\t\t\t");
                    _builder.append(".map( e -> e.getAsInt()).collect(java.util.stream.Collectors.toList())) : java.util.Collections.emptyList();");
                    _builder.newLine();
                } else {
                    String _plainType_2 = GsonGenerator.getPlainType(p);
                    boolean _equals_2 = Objects.equals(_plainType_2, "double");
                    if (_equals_2) {
                        _builder.append("this.");
                        String _name_6 = p.getName();
                        _builder.append(_name_6);
                        _builder.append(" = jsonObject.has(\"");
                        String _name_7 = p.getName();
                        _builder.append(_name_7);
                        _builder.append("\") ? java.util.Collections.unmodifiableList(java.util.stream.StreamSupport.stream( jsonObject.getAsJsonArray(\"");
                        String _name_8 = p.getName();
                        _builder.append(_name_8);
                        _builder.append("\").spliterator(), false )");
                        _builder.newLineIfNotEmpty();
                        _builder.append("\t\t\t\t\t\t");
                        _builder.append(".map( e -> e.getAsDouble()).collect(java.util.stream.Collectors.toList())) : java.util.Collections.emptyList();");
                        _builder.newLine();
                    } else {
                        String _plainType_3 = GsonGenerator.getPlainType(p);
                        boolean _equals_3 = Objects.equals(_plainType_3, "String");
                        if (_equals_3) {
                            _builder.append("this.");
                            String _name_9 = p.getName();
                            _builder.append(_name_9);
                            _builder.append(" = jsonObject.has(\"");
                            String _name_10 = p.getName();
                            _builder.append(_name_10);
                            _builder.append("\") ? java.util.Collections.unmodifiableList(java.util.stream.StreamSupport.stream( jsonObject.getAsJsonArray(\"");
                            String _name_11 = p.getName();
                            _builder.append(_name_11);
                            _builder.append("\").spliterator(), false )");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t\t\t\t\t\t");
                            _builder.append(".map( e -> e.getAsString()).collect(java.util.stream.Collectors.toList())) : java.util.Collections.emptyList();");
                            _builder.newLine();
                        } else {
                            _builder.append("this.");
                            String _name_12 = p.getName();
                            _builder.append(_name_12);
                            _builder.append(" = jsonObject.has(\"");
                            String _name_13 = p.getName();
                            _builder.append(_name_13);
                            _builder.append("\") ? java.util.Collections.unmodifiableList(java.util.stream.StreamSupport.stream( jsonObject.getAsJsonArray(\"");
                            String _name_14 = p.getName();
                            _builder.append(_name_14);
                            _builder.append("\").spliterator(), false )");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t\t\t\t\t\t");
                            _builder.append(".map( e -> GsonElementFactory.create");
                            String _name_15 = p.getRef().getName();
                            _builder.append(_name_15, "\t\t\t\t\t\t");
                            _builder.append("(e.getAsJsonObject())).collect(java.util.stream.Collectors.toList())) : java.util.Collections.emptyList();");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                }
            }
        } else {
            String _type = GsonGenerator.getType(p);
            boolean _equals_4 = Objects.equals(_type, "boolean");
            if (_equals_4) {
                boolean _notEquals;
                _builder.append("this.");
                String _name_16 = p.getName();
                _builder.append(_name_16);
                _builder.append(" = jsonObject.has(\"");
                String _name_17 = p.getName();
                _builder.append(_name_17);
                _builder.append("\") ? jsonObject.get(\"");
                String _name_18 = p.getName();
                _builder.append(_name_18);
                _builder.append("\").getAsBoolean() : ");
                String _value = Util.getValue(p);
                boolean bl = _notEquals = !Objects.equals(_value, null);
                if (_notEquals) {
                    String _value_1 = Util.getValue(p);
                    _builder.append(_value_1);
                } else {
                    _builder.append("false");
                }
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            } else {
                String _type_1 = GsonGenerator.getType(p);
                boolean _equals_5 = Objects.equals(_type_1, "int");
                if (_equals_5) {
                    boolean _notEquals_1;
                    _builder.append("this.");
                    String _name_19 = p.getName();
                    _builder.append(_name_19);
                    _builder.append(" = jsonObject.has(\"");
                    String _name_20 = p.getName();
                    _builder.append(_name_20);
                    _builder.append("\") ? jsonObject.get(\"");
                    String _name_21 = p.getName();
                    _builder.append(_name_21);
                    _builder.append("\").getAsInt() : ");
                    String _value_2 = Util.getValue(p);
                    boolean bl = _notEquals_1 = !Objects.equals(_value_2, null);
                    if (_notEquals_1) {
                        String _value_3 = Util.getValue(p);
                        _builder.append(_value_3);
                    } else {
                        _builder.append("0");
                    }
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                } else {
                    String _type_2 = GsonGenerator.getType(p);
                    boolean _equals_6 = Objects.equals(_type_2, "double");
                    if (_equals_6) {
                        boolean _notEquals_2;
                        _builder.append("this.");
                        String _name_22 = p.getName();
                        _builder.append(_name_22);
                        _builder.append(" = jsonObject.has(\"");
                        String _name_23 = p.getName();
                        _builder.append(_name_23);
                        _builder.append("\") ? jsonObject.get(\"");
                        String _name_24 = p.getName();
                        _builder.append(_name_24);
                        _builder.append("\").getAsDouble() : ");
                        String _value_4 = Util.getValue(p);
                        boolean bl = _notEquals_2 = !Objects.equals(_value_4, null);
                        if (_notEquals_2) {
                            String _value_5 = Util.getValue(p);
                            _builder.append(_value_5);
                        } else {
                            _builder.append("0.0");
                        }
                        _builder.append(";");
                        _builder.newLineIfNotEmpty();
                    } else {
                        String _type_3 = GsonGenerator.getType(p);
                        boolean _equals_7 = Objects.equals(_type_3, "String");
                        if (_equals_7) {
                            boolean _notEquals_3;
                            _builder.append("this.");
                            String _name_25 = p.getName();
                            _builder.append(_name_25);
                            _builder.append(" = jsonObject.has(\"");
                            String _name_26 = p.getName();
                            _builder.append(_name_26);
                            _builder.append("\") ? jsonObject.get(\"");
                            String _name_27 = p.getName();
                            _builder.append(_name_27);
                            _builder.append("\").getAsString() : ");
                            String _value_6 = Util.getValue(p);
                            boolean bl = _notEquals_3 = !Objects.equals(_value_6, null);
                            if (_notEquals_3) {
                                String _value_7 = Util.getValue(p);
                                _builder.append(_value_7);
                            } else {
                                _builder.append("null");
                            }
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                        } else {
                            boolean _notEquals_4;
                            _builder.append("this.");
                            String _name_28 = p.getName();
                            _builder.append(_name_28);
                            _builder.append(" = jsonObject.has(\"");
                            String _name_29 = p.getName();
                            _builder.append(_name_29);
                            _builder.append("\") ? GsonElementFactory.create");
                            String _name_30 = p.getRef().getName();
                            _builder.append(_name_30);
                            _builder.append("(jsonObject.getAsJsonObject(\"");
                            String _name_31 = p.getName();
                            _builder.append(_name_31);
                            _builder.append("\")) : ");
                            String _value_8 = Util.getValue(p);
                            boolean bl = _notEquals_4 = !Objects.equals(_value_8, null);
                            if (_notEquals_4) {
                                String _value_9 = Util.getValue(p);
                                _builder.append(_value_9);
                            } else {
                                _builder.append("null");
                            }
                            _builder.append(";");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                }
            }
        }
        return _builder;
    }

    public CharSequence generatePropertyEntry(GDomainProperty p) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private final ");
        String _type = GsonGenerator.getType(p);
        _builder.append(_type);
        _builder.append(" ");
        String _name = p.getName();
        _builder.append(_name);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        String _type_1 = GsonGenerator.getType(p);
        _builder.append(_type_1);
        _builder.append(" ");
        String _type_2 = GsonGenerator.getType(p);
        boolean _equals = Objects.equals(_type_2, "boolean");
        if (_equals) {
            _builder.append("is");
        } else {
            _builder.append("get");
        }
        String _firstUpper = StringExtensions.toFirstUpper((String)p.getName());
        _builder.append(_firstUpper);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return this.");
        String _name_1 = p.getName();
        _builder.append(_name_1, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateDeserializer(GModel m) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        String _name = m.getName();
        _builder.append(_name);
        _builder.append(".gson;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import ");
        String _name_1 = m.getName();
        _builder.append(_name_1);
        _builder.append(".*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import com.google.gson.JsonObject;");
        _builder.newLine();
        _builder.append("import com.google.gson.JsonArray;");
        _builder.newLine();
        _builder.newLine();
        String _lastSegment = m.eResource().getURI().lastSegment();
        int _length = m.eResource().getURI().lastSegment().length();
        int _minus = _length - 5;
        String name = _lastSegment.substring(0, _minus);
        _builder.newLineIfNotEmpty();
        _builder.append("public final class GsonElementFactory implements ");
        _builder.append(name);
        _builder.append("GModel {");
        _builder.newLineIfNotEmpty();
        EList<GDomainElement> _typeList = m.getTypeList();
        for (GDomainElement t : _typeList) {
            _builder.append("\t");
            _builder.append("public static ");
            String _name_2 = t.getName();
            _builder.append(_name_2, "\t");
            _builder.append(" create");
            String _name_3 = t.getName();
            _builder.append(_name_3, "\t");
            _builder.append("(JsonObject o) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if( o.has(\"$gtype\") ) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("switch( o.get(\"$gtype\").getAsString() ) {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.append("case \"");
            String _name_4 = t.getName();
            _builder.append(_name_4, "\t\t\t\t");
            _builder.append("\":");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t\t\t");
            _builder.append("return new Gson");
            String _name_5 = t.getName();
            _builder.append(_name_5, "\t\t\t\t\t");
            _builder.append("Impl(o);");
            _builder.newLineIfNotEmpty();
            List<GDomainElement> _allImpl = GsonGenerator.getAllImpl(t, m);
            for (GDomainElement sub : _allImpl) {
                _builder.append("\t");
                _builder.append("\t\t\t");
                _builder.append("case \"");
                String _name_6 = sub.getName();
                _builder.append(_name_6, "\t\t\t\t");
                _builder.append("\":");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t\t\t");
                _builder.append("\t");
                _builder.append("return new Gson");
                String _name_7 = sub.getName();
                _builder.append(_name_7, "\t\t\t\t\t");
                _builder.append("Impl(o);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("\t\t\t");
            _builder.append("default:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t\t\t");
            _builder.append("throw new IllegalStateException();");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("} else {");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("return new Gson");
            String _name_8 = t.getName();
            _builder.append(_name_8, "\t\t\t");
            _builder.append("Impl(o);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public ");
            String _name_9 = t.getName();
            _builder.append(_name_9, "\t");
            _builder.append(".Builder ");
            String _name_10 = t.getName();
            _builder.append(_name_10, "\t");
            _builder.append("Builder() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return new Gson");
            String _name_11 = t.getName();
            _builder.append(_name_11, "\t\t");
            _builder.append("Impl.Builder(this);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public <T extends ");
        _builder.append(name, "\t");
        _builder.append("Base> T createObject(java.io.Reader json) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("JsonObject o = new com.google.gson.Gson().fromJson( json, JsonObject.class);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return _createObject(o);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@SuppressWarnings(\"unchecked\")");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("private static <T extends ");
        _builder.append(name, "\t");
        _builder.append("Base> T _createObject(JsonObject o) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("if( o.has(\"$gtype\") ) {");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("switch( o.get(\"$gtype\").getAsString() ) {");
        _builder.newLine();
        EList<GDomainElement> _typeList_1 = m.getTypeList();
        for (GDomainElement t_1 : _typeList_1) {
            _builder.append("\t\t\t\t");
            _builder.append("case \"");
            String _name_12 = t_1.getName();
            _builder.append(_name_12, "\t\t\t\t");
            _builder.append("\":");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t\t");
            _builder.append("\t");
            _builder.append("return (T) create");
            String _name_13 = t_1.getName();
            _builder.append(_name_13, "\t\t\t\t\t");
            _builder.append("(o);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return (T) create");
        String _name_14 = ((GDomainElement)IterableExtensions.head(m.getTypeList())).getName();
        _builder.append(_name_14, "\t\t");
        _builder.append("(o);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public <T extends ");
        _builder.append(name, "\t");
        _builder.append("Base> java.util.List<T> createList(java.io.Reader json) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("JsonArray ar = new com.google.gson.Gson().fromJson( json, JsonArray.class);");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return java.util.stream.StreamSupport.stream(ar.spliterator(), false)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".map( e -> (JsonObject)e)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".map( GsonElementFactory::<T>_createObject)");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append(".collect(java.util.stream.Collectors.toList());");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public String toString(");
        _builder.append(name, "\t");
        _builder.append("Base o) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return new com.google.gson.GsonBuilder().setPrettyPrinting().create().toJson( ((GsonBase)o).toJSONObject() );");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public String toString(java.util.List<");
        _builder.append(name, "\t");
        _builder.append("Base> o) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return new com.google.gson.GsonBuilder().setPrettyPrinting().create().toJson( GsonBase.toDomainJsonArray(o) );");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static List<GDomainElement> getAllImpl(GDomainElement e, GModel m) {
        Functions.Function1 _function = it -> !Objects.equals(it, e);
        Functions.Function1 _function_1 = it -> Util.collectHierarchicalList(it.getSuperTypeList()).contains(e);
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filter(m.getTypeList(), (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    public static String getType(GDomainProperty p) {
        boolean _isList = p.isList();
        if (_isList) {
            String _plainType = GsonGenerator.getPlainType(p);
            String _plus = "java.util.List<" + _plainType;
            return _plus + ">";
        }
        return GsonGenerator.getPlainType(p);
    }

    public static String getPlainType(GDomainProperty p) {
        String _xifexpression = null;
        String _builtIn = p.getBuiltIn();
        boolean _notEquals = !Objects.equals(_builtIn, null);
        _xifexpression = _notEquals ? Util.toJavaType(p.getBuiltIn()) : p.getRef().getName();
        return _xifexpression;
    }

    public static String getPlainType(GDomainMap p) {
        String _xifexpression = null;
        String _builtIn = p.getBuiltIn();
        boolean _notEquals = !Objects.equals(_builtIn, null);
        _xifexpression = _notEquals ? Util.toJavaType(p.getBuiltIn()) : p.getRef().getName();
        return _xifexpression;
    }
}

