/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.ICompareInputLabelProvider;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.CommitInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.model.impl.StringToFileInfoImpl;
import org.eclipse.egerrit.internal.ui.compare.CommentableCompareItem;
import org.eclipse.egerrit.internal.ui.compare.CompareItemFactory;
import org.eclipse.egerrit.internal.ui.compare.CompareUpperSection;
import org.eclipse.egerrit.internal.ui.compare.EditionLimiter;
import org.eclipse.egerrit.internal.ui.compare.EmptyTypedElement;
import org.eclipse.egerrit.internal.ui.compare.GerritCommentAnnotation;
import org.eclipse.egerrit.internal.ui.compare.GerritCompareInputLabelProvider;
import org.eclipse.egerrit.internal.ui.compare.GerritDiffNode;
import org.eclipse.egerrit.internal.ui.compare.PatchSetCompareItem;
import org.eclipse.egerrit.internal.ui.editors.OpenCompareEditor;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.WeakInterningHashSet;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritMultipleInput
extends SaveableCompareEditorInput {
    private static Logger logger = LoggerFactory.getLogger(GerritMultipleInput.class);
    private GerritDiffNode root;
    private ChangeInfo changeInfo;
    private FileInfo fileToReveal;
    DiffNode nodeToReveal;
    private String leftSide;
    private String rightSide;
    GerritClient gerritClient;
    private byte problemSavingChanges = (byte)-1;
    private Runnable postSaveListener;
    private WeakInterningHashSet<SourceViewer> decoratedViewers = new WeakInterningHashSet(3);
    private CompareViewerPane upperSection;

    public GerritMultipleInput(String leftSide, String rightSide, ChangeInfo changeInfo, GerritClient gerrit, FileInfo toReveal) {
        super(GerritMultipleInput.initConfiguration(), null);
        Assert.isNotNull((Object)leftSide);
        Assert.isNotNull((Object)rightSide);
        Assert.isNotNull((Object)changeInfo);
        this.leftSide = leftSide;
        this.rightSide = rightSide;
        this.changeInfo = changeInfo;
        this.fileToReveal = toReveal;
        this.gerritClient = gerrit;
        this.root = new GerritDiffNode(0){

            public boolean hasChildren() {
                return true;
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener listener) {
            }
        };
        this.root.setInput(this);
    }

    private static CompareConfiguration initConfiguration() {
        CompareConfiguration config = new CompareConfiguration();
        config.setDefaultLabelProvider((ICompareInputLabelProvider)new GerritCompareInputLabelProvider());
        return config;
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.resetRoot();
        this.nodeToReveal = null;
        if (this.leftSide.equals(this.rightSide)) {
            return this.root;
        }
        if (this.leftSide.equals("BASE")) {
            this.computeDifferencesWithBase(monitor);
        } else if (this.leftSide.equals("WORKSPACE")) {
            this.computeDifferencesWithWorkspace(monitor, false);
        } else if (this.rightSide.equals("WORKSPACE")) {
            this.computeDifferencesWithWorkspace(monitor, true);
        } else {
            this.computeDifferencesBetweenRevisions(monitor);
        }
        return this.root;
    }

    void switchInputs(String left, String right) {
        try {
            if (left == null && this.rightSide.equals(right)) {
                return;
            }
            if (right == null && this.leftSide.equals(left)) {
                return;
            }
            Object selectedElement = this.getSelectedEdition();
            if (selectedElement != null) {
                this.fileToReveal = ((GerritDiffNode)((Object)selectedElement)).getFileInfo();
            }
            if (left != null) {
                this.leftSide = left;
            }
            if (right != null) {
                this.rightSide = right;
            }
            this.prepareInput((IProgressMonitor)new NullProgressMonitor());
            this.upperSection.setInput((Object)this.root);
        }
        catch (InterruptedException | InvocationTargetException e) {
            logger.error("Problem while switching input to " + left + " " + right, (Throwable)e);
        }
    }

    public void resetRoot() {
        IDiffElement[] children;
        IDiffElement[] iDiffElementArray = children = this.root.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IDiffElement child = iDiffElementArray[n2];
            this.root.remove(child);
            ++n2;
        }
    }

    private void computeDifferencesBetweenRevisions(IProgressMonitor monitor) {
        this.loadRevision(this.leftSide);
        this.loadRevision(this.rightSide);
        Map<String, FileInfo> files = this.loadRevisionDiff();
        EMap leftFiles = ((RevisionInfo)this.changeInfo.getRevisions().get((Object)this.leftSide)).getFiles();
        EMap rightFiles = ((RevisionInfo)this.changeInfo.getRevisions().get((Object)this.rightSide)).getFiles();
        for (Map.Entry<String, FileInfo> file : files.entrySet()) {
            GerritDiffNode node = this.createRevisionRevisionNode(monitor, (EMap<String, FileInfo>)leftFiles, (EMap<String, FileInfo>)rightFiles, file.getValue(), file.getKey());
            if (node == null) continue;
            this.root.add((IDiffElement)node);
            this.setElementToReveal(node, node.getFileInfo());
        }
    }

    private Map<String, FileInfo> loadRevisionDiff() {
        Map files = null;
        try {
            files = (Map)this.gerritClient.getFilesModifiedSince(this.changeInfo.getId(), this.rightSide, this.leftSide).call();
        }
        catch (EGerritException e) {
            logger.debug("An exception occurred while getting the diff between revision " + this.leftSide + " and " + this.rightSide, (Throwable)e);
        }
        return files;
    }

    private GerritDiffNode createRevisionRevisionNode(IProgressMonitor monitor, EMap<String, FileInfo> leftFiles, EMap<String, FileInfo> rightFiles, FileInfo fileToShow, String filePathToShow) {
        String fileName = filePathToShow;
        GerritDiffNode node = new GerritDiffNode(this.getDifferenceFlag(fileToShow));
        FileInfo referenceFile = null;
        FileInfo matchForRight = (FileInfo)rightFiles.get((Object)fileName);
        FileInfo matchForLeft = (FileInfo)leftFiles.get((Object)(matchForRight != null ? this.getOldPathOrPath(matchForRight) : filePathToShow));
        if (matchForRight == null && matchForLeft == null) {
            logger.debug("File " + filePathToShow + " found in either revision " + this.leftSide + " or " + this.rightSide);
            return null;
        }
        FileInfo fileInfo = referenceFile = matchForRight != null ? matchForRight : matchForLeft;
        if (matchForRight != null) {
            node.setRight(new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(fileName, this.changeInfo.getId(), matchForRight, monitor));
            node.setFileInfo(matchForRight);
        } else {
            node.setRight(new CompareItemFactory(this.gerritClient).createCompareItemFromCommit(this.changeInfo.getProject(), this.getBaseCommitId(referenceFile), referenceFile, monitor));
            node.setFileInfo(referenceFile);
        }
        if (matchForLeft != null) {
            node.setLeft(new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(fileName, this.changeInfo.getId(), matchForLeft, monitor));
        } else if (!fileToShow.getStatus().equals("A")) {
            String baseCommitId = this.getBaseCommitId(referenceFile);
            if (baseCommitId != null) {
                node.setLeft(new CompareItemFactory(this.gerritClient).createCompareItemFromCommit(this.changeInfo.getProject(), this.getBaseCommitId(referenceFile), referenceFile, monitor));
            } else {
                node.setLeft(new EmptyTypedElement(filePathToShow));
            }
        } else {
            node.setLeft(new EmptyTypedElement(filePathToShow));
        }
        return node;
    }

    private int getDifferenceFlag(FileInfo file) {
        switch (file.getStatus()) {
            case "A": {
                return 1;
            }
            case "R": {
                return 4;
            }
            case "D": {
                return 2;
            }
            case "C": {
                return 3;
            }
        }
        return 3;
    }

    private String getOldPathOrPath(FileInfo file) {
        if (file.getOld_path() == null) {
            return file.getPath();
        }
        return file.getOld_path();
    }

    private void computeDifferencesWithWorkspace(IProgressMonitor monitor, boolean workspaceOnRight) {
        this.loadRevision(workspaceOnRight ? this.leftSide : this.rightSide);
        RevisionInfo filesToShow = (RevisionInfo)this.changeInfo.getRevisions().get((Object)(workspaceOnRight ? this.leftSide : this.rightSide));
        for (FileInfo file : filesToShow.getFiles().values()) {
            GerritDiffNode node = this.createWorkspaceRevisionNode(monitor, file, workspaceOnRight);
            this.root.add((IDiffElement)node);
            this.setElementToReveal(node, file);
        }
    }

    private void loadRevision(String revision) {
        QueryHelpers.loadFiles(this.gerritClient, (RevisionInfo)this.changeInfo.getRevisions().get((Object)revision));
    }

    private GerritDiffNode createWorkspaceRevisionNode(IProgressMonitor monitor, FileInfo file, boolean workspaceOnRight) {
        String fileName = file.getPath();
        GerritDiffNode node = new GerritDiffNode(this.getDifferenceFlag(file));
        node.setFileInfo(file);
        PatchSetCompareItem revisionFile = new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(fileName, this.changeInfo.getId(), file, monitor);
        IFile workspaceFile = new OpenCompareEditor(this.gerritClient, this.changeInfo).getCorrespondingWorkspaceFile(file);
        if (workspaceFile == null) {
            workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("missing/" + fileName));
        }
        ITypedElement workspaceNode = GerritMultipleInput.createFileElement((IFile)workspaceFile);
        if (workspaceOnRight) {
            node.setRight(workspaceNode);
            node.setLeft(revisionFile);
        } else {
            node.setRight(revisionFile);
            node.setLeft(workspaceNode);
        }
        return node;
    }

    private void computeDifferencesWithBase(IProgressMonitor monitor) {
        String actualRightSide = this.rightSide.equals("WORKSPACE") ? this.changeInfo.getRevision().getId() : this.rightSide;
        this.loadRevision(actualRightSide);
        RevisionInfo rightRevision = (RevisionInfo)this.changeInfo.getRevisions().get((Object)actualRightSide);
        for (FileInfo rightFile : rightRevision.getFiles().values()) {
            GerritDiffNode node = null;
            node = this.rightSide.equals("WORKSPACE") ? this.createBaseWorkspaceNode(monitor, rightFile) : this.createBaseRevisionNode(monitor, rightFile);
            this.root.add((IDiffElement)node);
            this.setElementToReveal(node, rightFile);
        }
    }

    private GerritDiffNode createBaseWorkspaceNode(IProgressMonitor monitor, FileInfo rightFile) {
        String fileName = rightFile.getPath();
        GerritDiffNode node = new GerritDiffNode(this.getDifferenceFlag(rightFile));
        IFile workspaceFile = new OpenCompareEditor(this.gerritClient, this.changeInfo).getCorrespondingWorkspaceFile(rightFile);
        if (workspaceFile == null) {
            workspaceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("missing/" + fileName));
        }
        node.setRight(GerritMultipleInput.createFileElement((IFile)workspaceFile));
        node.setFileInfo(rightFile);
        String baseCommitId = this.getBaseCommitId(rightFile);
        if (baseCommitId != null) {
            node.setLeft(new CompareItemFactory(this.gerritClient).createCompareItemFromCommit(this.changeInfo.getProject(), baseCommitId, rightFile, monitor));
        } else {
            node.setLeft(new EmptyTypedElement(""));
        }
        return node;
    }

    private GerritDiffNode createBaseRevisionNode(IProgressMonitor monitor, FileInfo rightFile) {
        String fileName = rightFile.getPath();
        GerritDiffNode node = new GerritDiffNode(this.getDifferenceFlag(rightFile));
        node.setFileInfo(rightFile);
        node.setRight(new CompareItemFactory(this.gerritClient).createCompareItemFromRevision(fileName, this.changeInfo.getId(), rightFile, monitor));
        String baseCommitId = this.getBaseCommitId(rightFile);
        if (baseCommitId != null) {
            node.setLeft(new CompareItemFactory(this.gerritClient).createCompareItemFromCommit(this.changeInfo.getProject(), baseCommitId, rightFile, monitor));
        } else {
            node.setLeft(new EmptyTypedElement(""));
        }
        return node;
    }

    private void setElementToReveal(GerritDiffNode node, FileInfo file) {
        if (this.fileToReveal == null) {
            return;
        }
        if (file.getPath().equals(this.fileToReveal.getPath())) {
            this.nodeToReveal = node;
            this.preloadNode(node);
        }
    }

    private void preloadNode(GerritDiffNode node) {
        if (node.getLeft() instanceof IStreamContentAccessor) {
            try {
                ((IStreamContentAccessor)node.getLeft()).getContents();
            }
            catch (CoreException e) {
                logger.debug("Problem preloading left", (Throwable)e);
            }
        }
        if (node.getRight() instanceof IStreamContentAccessor) {
            try {
                ((IStreamContentAccessor)node.getRight()).getContents();
            }
            catch (CoreException e) {
                logger.debug("Problem preloading right", (Throwable)e);
            }
        }
    }

    public String getTitle() {
        return String.valueOf(Messages.GerritMultipleInput_1) + this.changeInfo.get_number() + " - " + this.changeInfo.getSubject() + " -- " + this.getComparisonTitle();
    }

    private String getComparisonTitle() {
        String result = "";
        result = this.leftSide.equals("BASE") || this.leftSide.equals("WORKSPACE") ? String.valueOf(result) + this.leftSide : String.valueOf(result) + Messages.GerritMultipleInput_7 + ((RevisionInfo)this.changeInfo.getRevisions().get((Object)this.leftSide)).get_number();
        result = this.rightSide.equals("WORKSPACE") ? String.valueOf(result) + Messages.GerritMultipleInput_9 : String.valueOf(result) + Messages.GerritMultipleInput_10 + ((RevisionInfo)this.changeInfo.getRevisions().get((Object)this.rightSide)).get_number();
        return result;
    }

    private String getBaseCommitId(FileInfo fileInfo) {
        EList parents = fileInfo.getRevision().getCommit().getParents();
        if (parents == null || parents.isEmpty()) {
            return null;
        }
        return ((CommitInfo)parents.get(0)).getCommit();
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        Viewer newViewer = super.findContentViewer(oldViewer, input, parent);
        if (oldViewer == newViewer) {
            return newViewer;
        }
        if (this.isCommentable(input.getLeft())) {
            this.setupCommentColorer(newViewer, 0);
        }
        if (this.isCommentable(input.getRight())) {
            this.setupCommentColorer(newViewer, 1);
        }
        return newViewer;
    }

    private boolean isCommentable(ITypedElement element) {
        return element instanceof CommentableCompareItem;
    }

    private void setupCommentColorer(Viewer contentViewer, int side) {
        if (!(contentViewer instanceof TextMergeViewer)) {
            return;
        }
        TextMergeViewer textMergeViewer = (TextMergeViewer)contentViewer;
        try {
            Class<TextMergeViewer> clazz = TextMergeViewer.class;
            Field declaredField = clazz.getDeclaredField(side == 0 ? "fLeft" : "fRight");
            declaredField.setAccessible(true);
            MergeSourceViewer rightSourceViewer = (MergeSourceViewer)declaredField.get(textMergeViewer);
            Field sourceViewerField = MergeSourceViewer.class.getDeclaredField("fSourceViewer");
            sourceViewerField.setAccessible(true);
            final SourceViewer sourceViewer = (SourceViewer)sourceViewerField.get(rightSourceViewer);
            if (this.decoratedViewers.contains((Object)sourceViewer)) {
                return;
            }
            this.decoratedViewers.add((Object)sourceViewer);
            final AnnotationPainter commentPainter = this.initializeCommentColoring((ISourceViewer)sourceViewer);
            sourceViewer.addTextInputListener(new ITextInputListener(){
                EditionLimiter editionLimiter;
                {
                    this.editionLimiter = new EditionLimiter((TextViewer)sourceViewer2);
                }

                public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                    sourceViewer.addTextPresentationListener((ITextPresentationListener)commentPainter);
                    sourceViewer.addPainter((IPainter)commentPainter);
                    sourceViewer.getTextWidget().addVerifyListener((VerifyListener)this.editionLimiter);
                    if (oldInput instanceof CommentableCompareItem) {
                        ((CommentableCompareItem)oldInput).reset();
                    }
                }

                public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
                    if (oldInput != null) {
                        sourceViewer.removePainter((IPainter)commentPainter);
                        sourceViewer.addTextPresentationListener((ITextPresentationListener)commentPainter);
                        sourceViewer.getTextWidget().removeVerifyListener((VerifyListener)this.editionLimiter);
                    }
                }
            });
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException t) {
            logger.error("Problem while setting up coloration of comments", (Throwable)t);
        }
    }

    private AnnotationPainter initializeCommentColoring(ISourceViewer viewer) {
        AnnotationPainter commentPainter = new AnnotationPainter(viewer, null){

            protected IAnnotationModel findAnnotationModel(ISourceViewer sourceViewer) {
                if (sourceViewer.getDocument() instanceof CommentableCompareItem) {
                    return ((CommentableCompareItem)sourceViewer.getDocument()).getEditableComments();
                }
                return null;
            }
        };
        Object strategyID = new Object();
        AnnotationPainter.HighlightingStrategy paintingStrategy = new AnnotationPainter.HighlightingStrategy();
        commentPainter.addTextStyleStrategy(strategyID, (AnnotationPainter.ITextStyleStrategy)paintingStrategy);
        commentPainter.addAnnotationType((Object)GerritCommentAnnotation.TYPE, strategyID);
        commentPainter.setAnnotationTypeColor((Object)GerritCommentAnnotation.TYPE, Display.getCurrent().getSystemColor(7));
        commentPainter.addHighlightAnnotationType(strategyID);
        return commentPainter;
    }

    public void saveChanges(IProgressMonitor monitor) throws CoreException {
        try {
            super.saveChanges(monitor);
            this.forceSaveWorkspaceFile(monitor);
        }
        catch (RuntimeException ex) {
            if (CommentableCompareItem.class.getName().equals(ex.getMessage())) {
                if (ex.getCause().getMessage().equals(((GerritDiffNode)((Object)this.getSelectedEdition())).getLeft())) {
                    this.problemSavingChanges = 0;
                    this.setLeftDirty(true);
                } else {
                    this.problemSavingChanges = 1;
                    this.setRightDirty(true);
                }
                throw new CoreException((IStatus)new Status(4, "org.eclipse.egerrit.ui", Messages.GerritMultipleInput_11));
            }
            throw ex;
        }
        if (this.postSaveListener != null) {
            this.postSaveListener.run();
        }
    }

    private void forceSaveWorkspaceFile(IProgressMonitor monitor) throws CoreException {
        if (this.getSelectedEdition() != null) {
            ITypedElement forceright;
            ITypedElement forceLeft = ((GerritDiffNode)((Object)this.getSelectedEdition())).getLeft();
            if (forceLeft instanceof LocalResourceTypedElement) {
                ((LocalResourceTypedElement)forceLeft).commit(monitor);
            }
            if ((forceright = ((GerritDiffNode)((Object)this.getSelectedEdition())).getRight()) instanceof LocalResourceTypedElement) {
                ((LocalResourceTypedElement)forceright).commit(monitor);
            }
        }
    }

    public void setDirty(boolean dirty) {
        if (this.problemSavingChanges == 0) {
            super.setDirty(true);
            this.problemSavingChanges = (byte)-1;
            this.setLeftDirty(true);
        } else if (this.problemSavingChanges == 1) {
            super.setDirty(true);
            this.problemSavingChanges = (byte)-1;
            this.setRightDirty(true);
        } else {
            super.setDirty(dirty);
        }
    }

    public String getName() {
        if (this.fileToReveal != null) {
            return ((StringToFileInfoImpl)this.fileToReveal.eContainer()).getKey();
        }
        return "";
    }

    public void fireInputChange() {
        GerritDiffNode savedElement = (GerritDiffNode)((Object)this.getSelectedEdition());
        NullProgressMonitor pm = new NullProgressMonitor();
        boolean workspaceOnRight = this.rightSide.equals("WORKSPACE");
        Object newEntry = null;
        if (!workspaceOnRight) {
            if (this.leftSide.equals("BASE")) {
                newEntry = this.createBaseRevisionNode((IProgressMonitor)pm, savedElement.getFileInfo());
            } else if (this.leftSide.equals("WORKSPACE")) {
                newEntry = this.createWorkspaceRevisionNode((IProgressMonitor)pm, savedElement.getFileInfo(), false);
            } else {
                this.loadRevision(this.leftSide);
                this.loadRevision(this.rightSide);
                newEntry = this.createRevisionRevisionNode((IProgressMonitor)pm, (EMap<String, FileInfo>)((RevisionInfo)this.changeInfo.getRevisions().get((Object)this.leftSide)).getFiles(), (EMap<String, FileInfo>)((RevisionInfo)this.changeInfo.getRevisions().get((Object)this.rightSide)).getFiles(), savedElement.getFileInfo(), savedElement.getFileInfo().getPath());
            }
        }
        if (workspaceOnRight) {
            newEntry = this.leftSide.equals("BASE") ? this.createBaseWorkspaceNode((IProgressMonitor)pm, savedElement.getFileInfo()) : (this.leftSide.equals("WORKSPACE") ? null : this.createWorkspaceRevisionNode((IProgressMonitor)pm, savedElement.getFileInfo(), true));
        }
        if (newEntry != null) {
            savedElement.setRight(newEntry.getRight());
            savedElement.setLeft(newEntry.getLeft());
        }
        savedElement.fireChange();
    }

    protected ICompareInput prepareCompareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        return null;
    }

    protected CompareViewerPane createStructureInputPane(Composite parent) {
        this.upperSection = new CompareUpperSection(parent, 0x800800, true, (CompareEditorInput)this);
        return this.upperSection;
    }

    public ChangeInfo getChangeInfo() {
        return this.changeInfo;
    }

    public String getLeftSide() {
        return this.leftSide;
    }

    public String getRightSide() {
        return this.rightSide;
    }
}

