/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclipse.egerrit.internal.ui.compare.CommentableCompareItem;
import org.eclipse.egerrit.internal.ui.compare.GerritCommentAnnotation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.link.InclusivePositionUpdater;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditionLimiter
implements VerifyListener,
IDocumentListener {
    private static Logger logger = LoggerFactory.getLogger(EditionLimiter.class);
    private IDocument document;
    private AnnotationModel annotations;
    private TextViewer textViewer;
    private StyledText textWidget;
    private String lastTextForShortCircuiting = null;
    private boolean triggeredFromWidget = false;

    public EditionLimiter(TextViewer viewer) {
        this.textViewer = viewer;
        this.textViewer.getTextWidget().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 100 || (e.stateMask & 0x400000) == 0x400000 && e.keyCode == 100) {
                    EditionLimiter.this.triggeredFromWidget = true;
                    StyledText txt = (StyledText)e.getSource();
                    int lineLength = 0;
                    int lineNo = 0;
                    int caretOffset = txt.getCaretOffset();
                    if (EditionLimiter.this.document == null) {
                        EditionLimiter.this.initialize();
                    }
                    try {
                        lineNo = EditionLimiter.this.document.getLineOfOffset(caretOffset);
                        lineLength = EditionLimiter.this.document.getLineLength(lineNo);
                        if (!EditionLimiter.this.isEditableLine(EditionLimiter.this.document.getLineOffset(lineNo), 1)) {
                            return;
                        }
                        try {
                            EditionLimiter.this.doit(caretOffset, lineLength - 1, "", false, true);
                            EditionLimiter.this.document.replace(EditionLimiter.this.document.getLineOffset(lineNo), lineLength - 1, "");
                        }
                        catch (BadLocationException e1) {
                            logger.debug("Exception while performing Ctrl-D", (Throwable)e1);
                            return;
                        }
                    }
                    finally {
                        EditionLimiter.this.lastTextForShortCircuiting = null;
                        EditionLimiter.this.triggeredFromWidget = false;
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    /*
     * Exception decompiling
     */
    private boolean doit(int start, int length, String text, boolean fromDoc, boolean deletionOnly) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getNextLine(int offset) {
        try {
            return this.textWidget.getOffsetAtLine(this.textWidget.getLineAtOffset(offset) + 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
    }

    private boolean isBeginningOfLine(int offset) {
        return this.textWidget.getOffsetAtLine(this.textWidget.getLineAtOffset(offset)) == offset;
    }

    private boolean completelyIncludes(Position container, Position contained) {
        return container.includes(contained.offset) && container.includes(contained.offset + contained.length - 1);
    }

    private boolean isEditableLine(int offset, int length) {
        GerritCommentAnnotation annotation;
        Iterator it = this.annotations.getAnnotationIterator(offset, length, true, true);
        if (it.hasNext() && ((annotation = (GerritCommentAnnotation)((Object)it.next())).getComment() == null || annotation.getComment().getAuthor() == null)) {
            return true;
        }
        return this.isInsertingAtTheEndOfExistingComment(offset, length);
    }

    private GerritCommentAnnotation getCurrentAnnotation(int offset) {
        Iterator it = this.annotations.getAnnotationIterator();
        while (it.hasNext()) {
            GerritCommentAnnotation annotation = (GerritCommentAnnotation)((Object)it.next());
            Position position = this.annotations.getPosition((Annotation)annotation);
            if (offset < position.getOffset() || offset > position.getOffset() + position.getLength()) continue;
            return annotation;
        }
        return null;
    }

    private boolean isInsertingAtTheEndOfExistingComment(int offset, int length) {
        Iterator it = this.annotations.getAnnotationIterator();
        while (it.hasNext()) {
            Position position;
            GerritCommentAnnotation annotation = (GerritCommentAnnotation)((Object)it.next());
            if (annotation.getComment() != null && annotation.getComment().getAuthor() != null || (position = this.annotations.getPosition((Annotation)annotation)).getOffset() + position.getLength() != offset) continue;
            return true;
        }
        return false;
    }

    private void printAnnotationsCount() {
        try {
            logger.debug("Annotation count " + this.document.getPositions("__dflt_position_category").length);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public void verifyText(VerifyEvent e) {
        this.textWidget = (StyledText)e.widget;
        this.triggeredFromWidget = true;
        e.doit = this.doit(e.start, e.end - e.start, e.text, false, false);
        this.lastTextForShortCircuiting = e.text;
        this.triggeredFromWidget = false;
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        if (this.triggeredFromWidget) {
            return;
        }
        if (event.getText().equals(this.lastTextForShortCircuiting)) {
            return;
        }
        this.lastTextForShortCircuiting = event.getText();
        this.doit(event.getOffset(), event.getLength(), event.fText, true, true);
    }

    public void documentChanged(DocumentEvent event) {
        if (this.triggeredFromWidget) {
            return;
        }
        if (event.getText().equals(this.lastTextForShortCircuiting)) {
            this.lastTextForShortCircuiting = null;
            return;
        }
        this.doit(event.getOffset(), event.getLength(), event.fText, true, false);
        this.lastTextForShortCircuiting = null;
    }

    private void changePositionUpdater() {
        IPositionUpdater[] updaters;
        IPositionUpdater[] iPositionUpdaterArray = updaters = this.document.getPositionUpdaters();
        int n = updaters.length;
        int n2 = 0;
        while (n2 < n) {
            IPositionUpdater updater = iPositionUpdaterArray[n2];
            if (updater instanceof DefaultPositionUpdater) {
                try {
                    Method getCategory = DefaultPositionUpdater.class.getDeclaredMethod("getCategory", new Class[0]);
                    getCategory.setAccessible(true);
                    if ("__dflt_position_category".equals(getCategory.invoke((Object)updater, new Object[0]))) {
                        this.document.removePositionUpdater(updater);
                        break;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        this.document.addPositionUpdater((IPositionUpdater)new InclusivePositionUpdater("__dflt_position_category"));
    }

    private void initialize() {
        this.document = this.textViewer.getDocument();
        this.document.addDocumentListener((IDocumentListener)this);
        this.annotations = ((CommentableCompareItem)this.textViewer.getDocument()).getEditableComments();
        this.changePositionUpdater();
        this.textViewer.addTextInputListener(new ITextInputListener(){

            public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
                if (oldInput != null) {
                    oldInput.removeDocumentListener((IDocumentListener)EditionLimiter.this);
                }
                EditionLimiter.this.document = null;
            }

            public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            }
        });
    }
}

