/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.Status;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.compare.GerritMultipleInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;

public class SelectNextPatchSetHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent aEvent) {
        IEditorInput activeEditorInput = HandlerUtil.getActiveEditorInput((ExecutionEvent)aEvent);
        if (activeEditorInput instanceof GerritMultipleInput) {
            String commandName = aEvent.getCommand().getId();
            boolean isLeftSide = commandName.contains("selectLeftPatchSet");
            GerritMultipleInput input = (GerritMultipleInput)activeEditorInput;
            ArrayList revisions = new ArrayList(input.getChangeInfo().getRevisions().values());
            revisions.sort((o2, o1) -> o1.get_number() - o2.get_number());
            LinkedHashMap<String, String> patchNumber = new LinkedHashMap<String, String>();
            ListIterator iter = revisions.listIterator();
            while (iter.hasNext()) {
                RevisionInfo element = (RevisionInfo)iter.next();
                patchNumber.put(Integer.toString(element.get_number()), element.getId());
            }
            patchNumber.put("WORKSPACE", "WORKSPACE");
            patchNumber.put("BASE", "BASE");
            Iterator itr = patchNumber.entrySet().iterator();
            Iterator first = patchNumber.entrySet().iterator();
            boolean found = false;
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                if (isLeftSide && ((String)entry.getValue()).compareTo(input.getLeftSide()) == 0) {
                    entry = itr.hasNext() ? itr.next() : first.next();
                    input.switchInputs((String)entry.getValue(), null);
                    found = true;
                }
                if (!isLeftSide && ((String)entry.getValue()).compareTo(input.getRightSide()) == 0) {
                    entry = itr.hasNext() ? itr.next() : first.next();
                    input.switchInputs(null, (String)entry.getValue());
                    found = true;
                }
                if (found) break;
            }
        }
        return Status.OK_STATUS;
    }
}

