/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.provider;

import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.utils.Utils;
import org.eclipse.egerrit.internal.model.AccountInfo;
import org.eclipse.egerrit.internal.model.ChangeMessageInfo;
import org.eclipse.egerrit.internal.ui.EGerritImages;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class HistoryTableLabelProvider
extends ObservableMapLabelProvider
implements ITableLabelProvider {
    private static final String EMPTY_STRING = "";
    private GerritClient gerritClient;

    public HistoryTableLabelProvider(IObservableMap[] iObservableMaps, GerritClient gerritClient) {
        super(iObservableMaps);
        this.gerritClient = gerritClient;
    }

    public String getColumnText(Object aObj, int aIndex) {
        if (aObj instanceof ChangeMessageInfo) {
            ChangeMessageInfo changeMessageInfo = (ChangeMessageInfo)aObj;
            switch (aIndex) {
                case 0: {
                    return EMPTY_STRING;
                }
                case 1: {
                    return Utils.prettyPrintDate((String)changeMessageInfo.getDate());
                }
                case 2: {
                    if (changeMessageInfo.getAuthor() == null) break;
                    return changeMessageInfo.getAuthor().getName();
                }
                case 3: {
                    String msg = changeMessageInfo.getMessage().replaceAll("[\\t\\n\\r]", " ");
                    msg = msg.replaceFirst("([Pp]atch [Ss]et )(\\d[.:])", "$1 $2");
                    return msg;
                }
                default: {
                    return EMPTY_STRING;
                }
            }
        }
        return EMPTY_STRING;
    }

    public Image getColumnImage(Object aObj, int aIndex) {
        Image image = null;
        if (aObj instanceof ChangeMessageInfo) {
            ChangeMessageInfo changeMessageInfo = (ChangeMessageInfo)aObj;
            switch (aIndex) {
                case 0: {
                    boolean hasComments = changeMessageInfo.isComment();
                    if (!hasComments) break;
                    if (this.gerritClient.getRepository().getServerInfo().isAnonymous()) {
                        return EGerritImages.get("icons/showAnonymousComments.gif");
                    }
                    String currentUser = this.gerritClient.getRepository().getCredentials().getUsername();
                    AccountInfo author = changeMessageInfo.getAuthor();
                    if (author != null && (currentUser.equals(author.getEmail()) || currentUser.equals(author.getName()) || currentUser.equals(author.getUsername()))) {
                        return EGerritImages.get("icons/showAuthorComments.gif");
                    }
                    return EGerritImages.get("icons/showAnonymousComments.gif");
                }
                default: {
                    return image;
                }
            }
        }
        return image;
    }
}

