/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.provider;

import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.table.provider.SwitchCurrentPathsetAction;
import org.eclipse.egerrit.internal.ui.tabs.ObservableCollector;
import org.eclipse.egerrit.internal.ui.utils.DataConverter;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class PatchSetHandlerProvider {
    private ChangeInfo fChangeInfo;
    private GerritClient fGerritClient;
    private Label patchsetlabel;
    private DataBindingContext bindingContext = new DataBindingContext();
    private ObservableCollector observableCollector;

    public Button create(final Composite parent, ChangeInfo changeInfo, GerritClient gerritClient) {
        this.fChangeInfo = changeInfo;
        this.fGerritClient = gerritClient;
        this.patchsetlabel = new Label(parent, 0);
        Button fButtonPatchSet = new Button(parent, 1028);
        fButtonPatchSet.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        fButtonPatchSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuManager mgr = new MenuManager();
                PatchSetHandlerProvider.this.fillMenuItemForChangeInfo(mgr);
                mgr.createContextMenu((Control)parent).setVisible(true);
            }
        });
        this.patchsetSelectionBinding();
        return fButtonPatchSet;
    }

    private void fillMenuItemForChangeInfo(MenuManager menu) {
        ArrayList revisions = new ArrayList(this.fChangeInfo.getRevisions().values());
        revisions.sort((o1, o2) -> o2.get_number() - o1.get_number());
        revisions.stream().forEach(rev -> menu.add((IAction)new SwitchCurrentPathsetAction(this.fChangeInfo, (RevisionInfo)rev)));
    }

    private void patchsetSelectionBinding() {
        FeaturePath selectRevision = FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ModelPackage.Literals.CHANGE_INFO__USER_SELECTED_REVISION});
        IObservableValue observerValue = EMFProperties.value((FeaturePath)selectRevision).observe((Object)this.fChangeInfo);
        this.bindingContext.bindValue(Observables.observeDelayedValue((int)1000, (IObservableValue)WidgetProperties.text().observe((Widget)this.patchsetlabel)), Observables.observeDelayedValue((int)1000, (IObservableValue)observerValue), null, new UpdateValueStrategy().setConverter(DataConverter.patchSetSelected(this.fChangeInfo, this.fGerritClient)));
        IObservableValue observerRevisionsValue = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__CURRENT_REVISION).observe((Object)this.fChangeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.patchsetlabel), observerRevisionsValue, null, new UpdateValueStrategy().setConverter(DataConverter.patchSetSelected(this.fChangeInfo, this.fGerritClient)));
        this.observableCollector = new ObservableCollector(this.bindingContext);
    }

    public void dispose() {
        this.observableCollector.dispose();
        this.bindingContext.dispose();
    }
}

