/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.output.print;

import org.eclipse.escet.cif.simulator.CifSimulatorContext;
import org.eclipse.escet.cif.simulator.output.NormalOutputType;
import org.eclipse.escet.cif.simulator.output.NullSimulatorOutputComponent;
import org.eclipse.escet.cif.simulator.output.print.PrintTransitionKind;
import org.eclipse.escet.cif.simulator.output.print.RuntimePrintDecls;
import org.eclipse.escet.cif.simulator.runtime.SimulationResult;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;
import org.eclipse.escet.cif.simulator.runtime.transitions.EventTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.HistoryTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.TimeTransition;
import org.eclipse.escet.cif.simulator.runtime.transitions.Transition;

public class PrintOutputComponent
extends NullSimulatorOutputComponent {
    private final boolean enabled;
    private final RuntimePrintDecls printDecls;

    public PrintOutputComponent(RuntimePrintDecls printDecls, CifSimulatorContext ctxt) {
        this.enabled = ctxt.normal.contains((Object)NormalOutputType.PRINT);
        this.printDecls = printDecls;
        printDecls.init(ctxt);
    }

    @Override
    public void initialState(RuntimeState state) {
        if (!this.enabled) {
            return;
        }
        this.printDecls.print(state, state, PrintTransitionKind.INITIAL, -1);
    }

    @Override
    public void transitionTaken(RuntimeState sourceState, Transition<?> transition, RuntimeState targetState, Boolean interrupted) {
        if (!this.enabled) {
            return;
        }
        if (transition instanceof EventTransition) {
            EventTransition eventTrans = (EventTransition)transition;
            int eventIdx = eventTrans.event.idx;
            this.printDecls.print(sourceState, targetState, PrintTransitionKind.EVENT, eventIdx);
        } else if (transition instanceof TimeTransition) {
            this.printDecls.print(sourceState, targetState, PrintTransitionKind.TIME, -1);
        } else if (!(transition instanceof HistoryTransition)) {
            throw new RuntimeException("Unknown transition: " + String.valueOf(transition));
        }
    }

    @Override
    public void simulationEnded(SimulationResult rslt, RuntimeState state) {
        if (!this.enabled) {
            return;
        }
        this.printDecls.print(state, state, PrintTransitionKind.FINAL, -1);
        this.printDecls.close();
    }

    public void cleanup() {
        this.printDecls.close();
    }
}

