/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps.conversion;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifPreconditionChecker;
import org.eclipse.escet.cif.checkers.checks.AutOnlySpecificSupKindsCheck;
import org.eclipse.escet.cif.checkers.checks.AutOnlyWithCertainNumberOfInitLocsCheck;
import org.eclipse.escet.cif.checkers.checks.CompNoInitPredsCheck;
import org.eclipse.escet.cif.checkers.checks.CompNoMarkerPredsCheck;
import org.eclipse.escet.cif.checkers.checks.EdgeNoUpdatesCheck;
import org.eclipse.escet.cif.checkers.checks.EdgeNoUrgentCheck;
import org.eclipse.escet.cif.checkers.checks.EdgeOnlyStaticEvalGuardPredsCheck;
import org.eclipse.escet.cif.checkers.checks.EventNoChannelsCheck;
import org.eclipse.escet.cif.checkers.checks.EventNoTauCheck;
import org.eclipse.escet.cif.checkers.checks.EventOnlyReqSubsetPlantAlphabetCheck;
import org.eclipse.escet.cif.checkers.checks.EventOnlyWithControllabilityCheck;
import org.eclipse.escet.cif.checkers.checks.InvNoSpecificInvsCheck;
import org.eclipse.escet.cif.checkers.checks.LocNoUrgentCheck;
import org.eclipse.escet.cif.checkers.checks.LocOnlyStaticEvalInitPredsCheck;
import org.eclipse.escet.cif.checkers.checks.LocOnlyStaticEvalMarkerPredsCheck;
import org.eclipse.escet.cif.checkers.checks.SpecAutomataCountsCheck;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantPlaceKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantSupKind;
import org.eclipse.escet.cif.eventbased.apps.conversion.AutOnlyDeterministicCheck;
import org.eclipse.escet.cif.eventbased.apps.conversion.AutOnlyMarkedAndNonMarkedLocsCheck;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Termination;

public class ConvertToEventBasedPreChecker
extends CifPreconditionChecker {
    public ConvertToEventBasedPreChecker(boolean allowPlainEvents, boolean allowNonDeterminism, ExpectedNumberOfAutomata expectedNumberOfAutomata, EnumSet<SupKind> disallowedAutSupKinds, boolean requireAutHasInitLoc, boolean requireReqSubsetPlantAlphabet, boolean requireAutMarkedAndNonMarked, Termination termination) {
        super(termination, ConvertToEventBasedPreChecker.getChecks(allowPlainEvents, allowNonDeterminism, expectedNumberOfAutomata, disallowedAutSupKinds, requireAutHasInitLoc, requireReqSubsetPlantAlphabet, requireAutMarkedAndNonMarked));
    }

    private static List<CifCheck> getChecks(boolean allowPlainEvents, boolean allowNonDeterminism, ExpectedNumberOfAutomata expectedNumberOfAutomata, Set<SupKind> disallowedAutSupKinds, boolean requireAutHasInitLoc, boolean requireReqSubsetPlantAlphabet, boolean requireAutMarkedAndNonMarked) {
        List checks = Lists.list();
        if (allowPlainEvents) {
            checks.add(new EventNoTauCheck());
        } else {
            checks.add(new EventOnlyWithControllabilityCheck());
        }
        checks.add(new EventNoChannelsCheck());
        checks.add(new AutOnlyWithCertainNumberOfInitLocsCheck(requireAutHasInitLoc ? AutOnlyWithCertainNumberOfInitLocsCheck.AllowedNumberOfInitLocs.EXACTLY_ONE : AutOnlyWithCertainNumberOfInitLocsCheck.AllowedNumberOfInitLocs.AT_MOST_ONE));
        checks.add(new EdgeNoUpdatesCheck());
        checks.add(new LocNoUrgentCheck());
        checks.add(new EdgeNoUrgentCheck());
        checks.add(new CompNoInitPredsCheck());
        checks.add(new CompNoMarkerPredsCheck());
        checks.add(new LocOnlyStaticEvalInitPredsCheck());
        checks.add(new LocOnlyStaticEvalMarkerPredsCheck());
        checks.add(new InvNoSpecificInvsCheck().disallow(NoInvariantSupKind.ALL_KINDS, NoInvariantKind.ALL_KINDS, NoInvariantPlaceKind.ALL_PLACES).ignoreNeverBlockingInvariants());
        checks.add(new EdgeOnlyStaticEvalGuardPredsCheck());
        if (!allowNonDeterminism) {
            checks.add(new AutOnlyDeterministicCheck());
        }
        if (expectedNumberOfAutomata != null) {
            switch (expectedNumberOfAutomata) {
                case EXACTLY_ONE_AUTOMATON: {
                    checks.add(new SpecAutomataCountsCheck().setMinMaxAuts(1, 1));
                    break;
                }
                case EXACTLY_TWO_AUTOMATA: {
                    checks.add(new SpecAutomataCountsCheck().setMinMaxAuts(2, 2));
                    break;
                }
                case AT_LEAST_ONE_AUTOMATON: {
                    checks.add(new SpecAutomataCountsCheck().setMinMaxAuts(1, -1));
                    break;
                }
                case AT_LEAST_ONE_PLANT_AUTOMATON: {
                    checks.add(new SpecAutomataCountsCheck().setMinMaxPlantAuts(1, -1));
                    break;
                }
                case AT_LEAST_TWO_AUTOMATA: {
                    checks.add(new SpecAutomataCountsCheck().setMinMaxAuts(2, -1));
                    break;
                }
                case AT_LEAST_ONE_PLANT_EXACTLY_ONE_SUPERVISOR: {
                    checks.add(new SpecAutomataCountsCheck().setMinMaxPlantAuts(1, -1).setMinMaxSupervisorAuts(1, 1));
                }
            }
        }
        if (!disallowedAutSupKinds.isEmpty()) {
            checks.add(new AutOnlySpecificSupKindsCheck(EnumSet.copyOf(Sets.difference(EnumSet.allOf(SupKind.class), disallowedAutSupKinds))));
        }
        if (requireReqSubsetPlantAlphabet) {
            checks.add(new EventOnlyReqSubsetPlantAlphabetCheck());
        }
        if (requireAutMarkedAndNonMarked) {
            checks.add(new AutOnlyMarkedAndNonMarkedLocsCheck());
        }
        return checks;
    }

    public static enum ExpectedNumberOfAutomata {
        EXACTLY_ONE_AUTOMATON,
        EXACTLY_TWO_AUTOMATA,
        AT_LEAST_ONE_AUTOMATON,
        AT_LEAST_ONE_PLANT_AUTOMATON,
        AT_LEAST_TWO_AUTOMATA,
        AT_LEAST_ONE_PLANT_EXACTLY_ONE_SUPERVISOR;

    }
}

