/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.common;

import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BoolExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.CastExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ConstantExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DictPair;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ElifExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EnumLiteralExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FieldExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionCallExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.FunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IfExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.IntExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ProjectionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.RealExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ReceivedExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SetExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SliceExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StdLibFunctionExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.StringExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchCase;
import org.eclipse.escet.cif.metamodel.cif.expressions.SwitchExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TupleExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.UnaryExpression;
import org.eclipse.escet.cif.metamodel.cif.functions.InternalFunction;
import org.eclipse.escet.common.java.DependencyOrderer;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;

public class FuncLocalVarOrderer
extends DependencyOrderer<DiscVariable> {
    protected Set<DiscVariable> findDirectDependencies(DiscVariable variable) {
        if (variable.getValue() == null) {
            return Sets.set();
        }
        Expression value = (Expression)Lists.first((List)variable.getValue().getValues());
        Set rslt = Sets.set();
        FuncLocalVarOrderer.collectVariables(value, rslt);
        return rslt;
    }

    private static void collectVariables(Expression expr, Set<DiscVariable> variables) {
        if (expr instanceof BoolExpression) {
            return;
        }
        if (expr instanceof IntExpression) {
            return;
        }
        if (expr instanceof RealExpression) {
            return;
        }
        if (expr instanceof StringExpression) {
            return;
        }
        if (expr instanceof ReceivedExpression) {
            return;
        }
        if (expr instanceof CastExpression) {
            FuncLocalVarOrderer.collectVariables(((CastExpression)expr).getChild(), variables);
            return;
        }
        if (expr instanceof UnaryExpression) {
            FuncLocalVarOrderer.collectVariables(((UnaryExpression)expr).getChild(), variables);
            return;
        }
        if (expr instanceof BinaryExpression) {
            BinaryExpression bexpr = (BinaryExpression)expr;
            FuncLocalVarOrderer.collectVariables(bexpr.getLeft(), variables);
            FuncLocalVarOrderer.collectVariables(bexpr.getRight(), variables);
            return;
        }
        if (expr instanceof IfExpression) {
            IfExpression iexpr = (IfExpression)expr;
            for (Expression guard : iexpr.getGuards()) {
                FuncLocalVarOrderer.collectVariables(guard, variables);
            }
            FuncLocalVarOrderer.collectVariables(iexpr.getThen(), variables);
            for (ElifExpression elif : iexpr.getElifs()) {
                for (Expression guard : elif.getGuards()) {
                    FuncLocalVarOrderer.collectVariables(guard, variables);
                }
                FuncLocalVarOrderer.collectVariables(elif.getThen(), variables);
            }
            FuncLocalVarOrderer.collectVariables(iexpr.getElse(), variables);
            return;
        }
        if (expr instanceof SwitchExpression) {
            SwitchExpression sexpr = (SwitchExpression)expr;
            FuncLocalVarOrderer.collectVariables(sexpr.getValue(), variables);
            for (SwitchCase cse : sexpr.getCases()) {
                if (cse.getKey() != null) {
                    FuncLocalVarOrderer.collectVariables(cse.getKey(), variables);
                }
                FuncLocalVarOrderer.collectVariables(cse.getValue(), variables);
            }
            return;
        }
        if (expr instanceof ProjectionExpression) {
            ProjectionExpression pexpr = (ProjectionExpression)expr;
            FuncLocalVarOrderer.collectVariables(pexpr.getChild(), variables);
            FuncLocalVarOrderer.collectVariables(pexpr.getIndex(), variables);
            return;
        }
        if (expr instanceof SliceExpression) {
            SliceExpression sexpr = (SliceExpression)expr;
            FuncLocalVarOrderer.collectVariables(sexpr.getChild(), variables);
            if (sexpr.getBegin() != null) {
                FuncLocalVarOrderer.collectVariables(sexpr.getBegin(), variables);
            }
            if (sexpr.getEnd() != null) {
                FuncLocalVarOrderer.collectVariables(sexpr.getEnd(), variables);
            }
            return;
        }
        if (expr instanceof FunctionCallExpression) {
            FunctionCallExpression fexpr = (FunctionCallExpression)expr;
            for (Expression arg : fexpr.getArguments()) {
                FuncLocalVarOrderer.collectVariables(arg, variables);
            }
            FuncLocalVarOrderer.collectVariables(fexpr.getFunction(), variables);
            return;
        }
        if (expr instanceof ListExpression) {
            ListExpression lexpr = (ListExpression)expr;
            for (Expression elem : lexpr.getElements()) {
                FuncLocalVarOrderer.collectVariables(elem, variables);
            }
            return;
        }
        if (expr instanceof SetExpression) {
            SetExpression sexpr = (SetExpression)expr;
            for (Expression elem : sexpr.getElements()) {
                FuncLocalVarOrderer.collectVariables(elem, variables);
            }
            return;
        }
        if (expr instanceof TupleExpression) {
            TupleExpression texpr = (TupleExpression)expr;
            for (Expression field : texpr.getFields()) {
                FuncLocalVarOrderer.collectVariables(field, variables);
            }
            return;
        }
        if (expr instanceof DictExpression) {
            DictExpression dexpr = (DictExpression)expr;
            for (DictPair pair : dexpr.getPairs()) {
                FuncLocalVarOrderer.collectVariables(pair.getKey(), variables);
                FuncLocalVarOrderer.collectVariables(pair.getValue(), variables);
            }
            return;
        }
        if (expr instanceof ConstantExpression) {
            return;
        }
        if (expr instanceof EnumLiteralExpression) {
            return;
        }
        if (expr instanceof FieldExpression) {
            return;
        }
        if (expr instanceof StdLibFunctionExpression) {
            return;
        }
        if (expr instanceof FunctionExpression) {
            return;
        }
        if (expr instanceof DiscVariableExpression) {
            DiscVariable var = ((DiscVariableExpression)expr).getVariable();
            EObject parent = var.eContainer();
            if (parent instanceof InternalFunction) {
                variables.add(var);
            }
            return;
        }
        throw new RuntimeException("Unexpected expr: " + String.valueOf(expr));
    }
}

