/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.varorder.orderers;

import org.eclipse.escet.cif.bdd.varorder.helper.VarOrdererData;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrdererEffect;
import org.eclipse.escet.cif.bdd.varorder.orderers.VarOrderer;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public class RepeatVarOrderer
extends VarOrderer {
    private final VarOrderer orderer;
    private final int count;
    private final VarOrdererEffect intermediateEffect;
    private final VarOrdererEffect finalEffect;

    public RepeatVarOrderer(VarOrderer orderer, int count, VarOrdererEffect intermediateEffect, VarOrdererEffect finalEffect) {
        this.orderer = orderer;
        this.count = count;
        this.intermediateEffect = intermediateEffect;
        this.finalEffect = finalEffect;
        Assert.check((count >= 1 ? 1 : 0) != 0);
    }

    @Override
    public VarOrdererData order(VarOrdererData inputData, boolean dbgEnabled, int dbgLevel) {
        if (dbgEnabled) {
            inputData.helper.dbg(dbgLevel, "Applying an orderer repeatedly:", new Object[0]);
            inputData.helper.dbg(dbgLevel + 1, "Count: %s", this.count);
            inputData.helper.dbg(dbgLevel + 1, "Intermediate effect: %s", this.enumValueToParserArg(this.intermediateEffect));
            inputData.helper.dbg(dbgLevel + 1, "Final effect: %s", this.enumValueToParserArg(this.finalEffect));
            inputData.helper.dbg();
        }
        VarOrdererData currentData = inputData;
        int i = 0;
        while (i < this.count) {
            if (i > 0 && dbgEnabled) {
                inputData.helper.dbg();
            }
            if (dbgEnabled) {
                inputData.helper.dbg(dbgLevel + 1, "Repeated application %,d/%,d:", i + 1, this.count);
            }
            VarOrdererData ordererData = this.orderer.order(currentData, dbgEnabled, dbgLevel + 2);
            VarOrdererEffect effect = i == this.count - 1 ? this.finalEffect : this.intermediateEffect;
            currentData = new VarOrdererData(currentData, ordererData.varOrder, effect);
            ++i;
        }
        return currentData;
    }

    public String toString() {
        return Strings.fmt((String)"repeat(orderer=%s, count=%s, intermediate-effect=%s, final-effect=%s)", (Object[])new Object[]{this.orderer.toString(), this.count, this.enumValueToParserArg(this.intermediateEffect), this.enumValueToParserArg(this.finalEffect)});
    }
}

