/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.launch;

import com.google.gson.GsonBuilder;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channels;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.eclipse.glsp.server.di.GLSPModule;
import org.eclipse.glsp.server.jsonrpc.GLSPJsonrpcClient;
import org.eclipse.glsp.server.jsonrpc.GLSPJsonrpcServer;
import org.eclipse.glsp.server.jsonrpc.GsonConfigurator;
import org.eclipse.glsp.server.launch.GLSPServerLauncher;
import org.eclipse.glsp.server.protocol.GLSPServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;

public class DefaultGLSPServerLauncher
extends GLSPServerLauncher {
    public static final String START_UP_COMPLETE_MSG = "[GLSP-Server]:Startup completed";
    private static Logger log = Logger.getLogger(DefaultGLSPServerLauncher.class);
    private ExecutorService threadPool;
    private AsynchronousServerSocketChannel serverSocket;
    private CompletableFuture<Void> onShutdown;

    public DefaultGLSPServerLauncher(GLSPModule glspModule) {
        super(glspModule);
    }

    @Override
    public void start(String hostname, int port) {
        try {
            Future<Void> onClose = this.asyncRun(hostname, port);
            onClose.get();
            log.info((Object)"Stopped GLSP server");
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            log.error((Object)"Error during server close!", (Throwable)e);
        }
    }

    public Future<Void> asyncRun(String hostname, int port) throws IOException, InterruptedException, ExecutionException {
        this.onShutdown = new CompletableFuture();
        this.serverSocket = AsynchronousServerSocketChannel.open().bind(new InetSocketAddress(hostname, port));
        this.threadPool = Executors.newCachedThreadPool();
        CompletionHandler<AsynchronousSocketChannel, Void> handler = new CompletionHandler<AsynchronousSocketChannel, Void>(){

            @Override
            public void completed(AsynchronousSocketChannel result, Void attachment) {
                DefaultGLSPServerLauncher.this.serverSocket.accept(null, this);
                DefaultGLSPServerLauncher.this.createClientConnection(result);
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                log.error((Object)("Client Connection Failed: " + exc.getMessage()), exc);
            }
        };
        this.serverSocket.accept(null, handler);
        log.info((Object)("The GLSP server is ready to accept new client requests on port: " + port));
        System.out.println(START_UP_COMPLETE_MSG);
        return this.onShutdown;
    }

    private void createClientConnection(AsynchronousSocketChannel socketChannel) {
        Injector injector = this.createInjector();
        GsonConfigurator gsonConf = (GsonConfigurator)injector.getInstance(GsonConfigurator.class);
        try {
            try {
                InputStream in = Channels.newInputStream(socketChannel);
                OutputStream out = Channels.newOutputStream(socketChannel);
                Consumer<GsonBuilder> configureGson = builder -> {
                    GsonBuilder gsonBuilder = gsonConf.configureGsonBuilder((GsonBuilder)builder);
                };
                Function wrapper = Function.identity();
                GLSPJsonrpcServer glspServer = (GLSPJsonrpcServer)injector.getInstance(GLSPServer.class);
                Launcher launcher = Launcher.createIoLauncher((Object)glspServer, GLSPJsonrpcClient.class, (InputStream)in, (OutputStream)out, (ExecutorService)this.threadPool, wrapper, configureGson);
                glspServer.connect((GLSPJsonrpcClient)launcher.getRemoteProxy());
                log.info((Object)("Starting GLSP server connection for client " + socketChannel.getRemoteAddress()));
                launcher.startListening().get();
                log.info((Object)("Stopping GLSP server connection for client" + socketChannel.getRemoteAddress()));
                glspServer.shutdown();
            }
            catch (IOException | InterruptedException | ExecutionException ex) {
                log.error((Object)("Failed to create client connection " + ex.getMessage()), (Throwable)ex);
                try {
                    socketChannel.close();
                }
                catch (IOException e) {
                    log.error((Object)"Excpetion occured when trying to close socketChannel", (Throwable)e);
                }
            }
        }
        finally {
            try {
                socketChannel.close();
            }
            catch (IOException e) {
                log.error((Object)"Excpetion occured when trying to close socketChannel", (Throwable)e);
            }
        }
    }

    @Override
    public void shutdown() {
        log.info((Object)"Stopping all connections to the GLSP server...");
        if (this.serverSocket.isOpen()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                log.error((Object)("Failed to close serverSocket: " + e.getMessage()), (Throwable)e);
            }
        }
        this.threadPool.shutdown();
        this.onShutdown.complete(null);
        log.info((Object)"Stopped GLSP server");
    }
}

