/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.emf;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.glsp.server.actions.SaveModelAction;
import org.eclipse.glsp.server.emf.EMFEditingDomainFactory;
import org.eclipse.glsp.server.emf.EMFModelState;
import org.eclipse.glsp.server.features.core.model.RequestModelAction;
import org.eclipse.glsp.server.features.core.model.SourceModelStorage;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.glsp.server.utils.ClientOptionsUtil;

public class EMFSourceModelStorage
implements SourceModelStorage {
    private static Logger LOGGER = LogManager.getLogger((String)EMFSourceModelStorage.class.getSimpleName());
    @Inject
    protected EMFModelState modelState;
    @Inject
    protected EMFEditingDomainFactory editingDomainFactory;

    public void loadSourceModel(RequestModelAction action) {
        String sourceURI = (String)ClientOptionsUtil.getSourceUri((Map)action.getOptions()).orElseThrow(() -> new GLSPServerException("No source URI given to load model!"));
        URI resourceURI = URI.createFileURI((String)sourceURI);
        EditingDomain editingDomain = this.getOrCreateEditingDomain();
        this.doLoadSourceModel(editingDomain.getResourceSet(), resourceURI, action);
    }

    protected EditingDomain getOrCreateEditingDomain() {
        if (this.modelState.getEditingDomain() != null) {
            return this.modelState.getEditingDomain();
        }
        EditingDomain editingDomain = this.editingDomainFactory.createEditingDomain();
        this.setupResourceSet(editingDomain.getResourceSet());
        this.modelState.setEditingDomain(editingDomain);
        return editingDomain;
    }

    protected ResourceSet setupResourceSet(ResourceSet resourceSet) {
        EcorePackage.eINSTANCE.eClass();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        return resourceSet;
    }

    protected void doLoadSourceModel(ResourceSet resourceSet, URI sourceURI, RequestModelAction action) {
        this.loadResource(resourceSet, sourceURI);
    }

    protected Optional<EObject> loadResource(ResourceSet resourceSet, URI resourceURI) {
        return this.loadResource(resourceSet, resourceURI, EObject.class);
    }

    protected <T extends EObject> Optional<T> loadResource(ResourceSet resourceSet, URI resourceURI, Class<T> modelClass) {
        Resource resource = resourceSet.getResource(resourceURI, true);
        if (resource == null) {
            throw new GLSPServerException("Failed to load resource: " + resourceURI);
        }
        return resource.getContents().stream().filter(modelClass::isInstance).map(modelClass::cast).findFirst();
    }

    public void saveSourceModel(SaveModelAction action) {
        for (Resource resource : this.modelState.getResourceSet().getResources()) {
            if (resource.getURI() == null) continue;
            try {
                resource.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                LOGGER.error("Could not save resource: " + resource.getURI(), (Throwable)e);
                throw new GLSPServerException("Could not save model to file: " + resource.getURI(), (Throwable)e);
            }
        }
    }
}

