/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.groups;

import jakarta.validation.GroupDefinitionException;
import jakarta.validation.GroupSequence;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import jakarta.validation.groups.Default;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.Address;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.Car;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.ZipCodeCoherenceChecker;
import org.hibernate.beanvalidation.tck.tests.constraints.groups.ZipCodeCoherenceValidator;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="4.0.0")
public class DefaultGroupRedefinitionTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)DefaultGroupRedefinitionTest.webArchiveBuilder().withTestClass(DefaultGroupRedefinitionTest.class)).withClasses(Address.class, ZipCodeCoherenceChecker.class, ZipCodeCoherenceValidator.class, Car.class)).build();
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-redefiningdefaultgroup", id="a")
    public void testRedefiningDefaultGroup() {
        Address address = new Address();
        address.setStreet("Guldmyntgatan");
        address.setCity("Gothenborg");
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)address, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(NotNull.class).withMessage("Zipcode may not be null").withProperty("zipcode"));
        address.setZipcode("41841");
        constraintViolations = validator.validate((Object)address, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(ZipCodeCoherenceChecker.class).withMessage("Zip code is not coherent.").withPropertyPath(ConstraintViolationAssert.pathWith().bean()));
    }

    @Test
    @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-redefiningdefaultgroup", id="a")
    public void testValidatingAgainstRedefinedDefaultGroup() {
        Car car = new Car();
        car.setType("A");
        Validator validator = TestUtil.getValidatorUnderTest();
        Set constraintViolations = validator.validate((Object)car, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withMessage("Car type has to be between 2 and 20 characters."));
        constraintViolations = validator.validateProperty((Object)car, "type", new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withMessage("Car type has to be between 2 and 20 characters."));
        constraintViolations = validator.validateValue(Car.class, "type", (Object)"A", new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(Size.class).withMessage("Car type has to be between 2 and 20 characters."));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-redefiningdefaultgroup", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-redefiningdefaultgroup", id="d")})
    public void testGroupSequenceContainingDefault() {
        AddressWithDefaultInGroupSequence address = new AddressWithDefaultInGroupSequence();
        Validator validator = TestUtil.getValidatorUnderTest();
        try {
            validator.validate((Object)address, new Class[0]);
            Assert.fail((String)"It should not be allowed to have Default.class in the group sequence of a class.");
        }
        catch (GroupDefinitionException groupDefinitionException) {
            // empty catch block
        }
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-redefiningdefaultgroup", id="c"), @SpecAssertion(section="constraintdeclarationvalidationprocess-groupsequence-redefiningdefaultgroup", id="d")})
    public void testGroupSequenceWithNoImplicitDefaultGroup() {
        AddressWithNoImplicitDefaultGroupSequence address = new AddressWithNoImplicitDefaultGroupSequence();
        Validator validator = TestUtil.getValidatorUnderTest();
        try {
            validator.validate((Object)address, new Class[0]);
            Assert.fail((String)"A valid group sequence definition must contain the class itself as implicit default group.");
        }
        catch (GroupDefinitionException groupDefinitionException) {
            // empty catch block
        }
    }

    @GroupSequence(value={Default.class, Address.HighLevelCoherence.class})
    public class AddressWithDefaultInGroupSequence
    extends Address {
    }

    @GroupSequence(value={Address.HighLevelCoherence.class})
    public class AddressWithNoImplicitDefaultGroupSequence
    extends Address {
    }
}

