/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.grammar.rng;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.Location;
import org.junit.jupiter.api.Test;

public class RNGReferenceExtensionsTest
extends AbstractCacheBasedTest {
    @Test
    public void referenceOnDefineName() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<grammar xmlns=\"http://relaxng.org/ns/structure/1.0\">\r\n    <start>\r\n        <element name=\"addressBook\">\r\n            <zeroOrMore>\r\n                <element name=\"card\">\r\n                    <ref name=\"cardContent\"/>\r\n                </element>\r\n            </zeroOrMore>\r\n        </element>\r\n    </start>\r\n    <define name=\"cardCo|ntent\">\r\n        <element name=\"name\">\r\n            <text/>\r\n        </element>\r\n        <element name=\"email\">\r\n            <text/>\r\n        </element>\r\n    </define>\r\n</grammar>";
        this.testReferencesFor(xml, XMLAssert.l("test.rng", XMLAssert.r(6, 30, 6, 43)));
    }

    private void testReferencesFor(String xml, Location ... expectedItems) throws BadLocationException {
        XMLAssert.testReferencesFor(xml, "test.rng", expectedItems);
    }
}

