/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.propertytesters;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.linuxtools.vagrant.core.EnumVMStatus;
import org.eclipse.linuxtools.vagrant.core.IVagrantVM;

public class VMPropertyTester
extends PropertyTester {
    public static final String IS_RUNNING = "isRunning";
    public static final String IS_SHUTOFF = "isShutoff";
    public static final String IS_PAUSED = "isPaused";
    public static final String IS_REMOVABLE = "isRemovable";
    public static final String IS_UNKNOWN = "isUnknown";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IVagrantVM) {
            IVagrantVM vm = (IVagrantVM)receiver;
            switch (property) {
                case "isRunning": {
                    return this.checkIfStateMatchesExpectation(vm, EnumVMStatus.RUNNING, expectedValue);
                }
                case "isShutoff": {
                    return this.checkIfStateMatchesExpectation(vm, EnumVMStatus.SHUTOFF, expectedValue);
                }
                case "isUnknown": {
                    return this.checkIfStateMatchesExpectation(vm, EnumVMStatus.UNKNOWN, expectedValue);
                }
                case "isPaused": {
                    return this.checkIfStateMatchesExpectation(vm, EnumVMStatus.PAUSED, expectedValue);
                }
                case "isRemovable": {
                    return this.checkIfStateMatchesExpectation(vm, EnumVMStatus.SHUTOFF, expectedValue) || this.checkIfStateMatchesExpectation(vm, EnumVMStatus.UNKNOWN, expectedValue);
                }
            }
        }
        return false;
    }

    private boolean checkIfStateMatchesExpectation(IVagrantVM vm, EnumVMStatus expectedStatus, Object expectedMatch) {
        if (expectedMatch == null) {
            return false;
        }
        EnumVMStatus containerStatus = EnumVMStatus.fromStatusMessage((String)vm.state());
        return expectedMatch.equals(containerStatus == expectedStatus);
    }
}

