/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.Messages;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DockerConnectionWatcher
implements ISelectionListener {
    public static final String CONNECTION_FILE_NAME = "dockerselectedconnection.xml";
    private static DockerConnectionWatcher instance;
    private IDockerConnection connection;

    public static DockerConnectionWatcher getInstance() {
        if (instance == null) {
            instance = new DockerConnectionWatcher();
        }
        return instance;
    }

    private DockerConnectionWatcher() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.linuxtools.docker.ui.dockerExplorerView", (ISelectionListener)this);
        IDockerConnection selectedConnection = this.loadConnection();
        if (selectedConnection != null) {
            this.connection = selectedConnection;
        }
    }

    public void dispose() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.linuxtools.docker.ui.dockerExplorerView", (ISelectionListener)this);
    }

    public void setConnection(IDockerConnection connection) {
        this.connection = connection;
        if (connection != null) {
            this.saveConnection(connection);
        }
    }

    private void saveConnection(IDockerConnection connection) {
        IPath stateLocation = Activator.getDefault().getStateLocation();
        File connectionFile = stateLocation.append(CONNECTION_FILE_NAME).toFile();
        if (!connection.isOpen()) {
            return;
        }
        try {
            if (!connectionFile.exists()) {
                connectionFile.createNewFile();
            }
            try (PrintWriter p = new PrintWriter(new BufferedWriter(new FileWriter(connectionFile)));){
                p.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                String name = connection.getName();
                if (name.equals(Messages.getString("Unnamed"))) {
                    name = "";
                }
                p.print("<connection name=\"" + name + "\" uri=\"" + connection.getUri());
                if (connection.getUsername() != null) {
                    p.print("\" username=\"" + connection.getUsername());
                }
                p.println("\"/>");
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    private IDockerConnection loadConnection() {
        IDockerConnection connection;
        block5: {
            connection = null;
            IPath stateLocation = Activator.getDefault().getStateLocation();
            File connectionFile = stateLocation.append(CONNECTION_FILE_NAME).toFile();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            try {
                IDockerConnection[] connections;
                DocumentBuilder db = dbf.newDocumentBuilder();
                if (!connectionFile.exists()) break block5;
                Document d = db.parse(connectionFile);
                Element e = d.getDocumentElement();
                NodeList connectionNodes = e.getElementsByTagName("connection");
                if (connectionNodes == null || connectionNodes.getLength() == 0) {
                    return null;
                }
                Node n = connectionNodes.item(0);
                NamedNodeMap attrs = n.getAttributes();
                Node nameNode = attrs.getNamedItem("name");
                Node uriNode = attrs.getNamedItem("uri");
                Node usernameNode = attrs.getNamedItem("username");
                if (uriNode == null) break block5;
                String uri = uriNode.getNodeValue();
                String name = nameNode.getNodeValue();
                String username = null;
                if (usernameNode != null) {
                    username = usernameNode.getNodeValue();
                }
                for (IDockerConnection c : connections = DockerConnectionManager.getInstance().getConnections()) {
                    if (!c.getUri().equals(uri) || !c.getName().equals(name) || c.getUsername() != null && !c.getUsername().equals(username)) continue;
                    connection = c;
                    break;
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                Activator.log(e);
            }
        }
        return connection;
    }

    public IDockerConnection getConnection() {
        return this.connection;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        ITreeSelection treeSelection = (ITreeSelection)selection;
        if (treeSelection.isEmpty()) {
            this.setConnection(null);
            return;
        }
        Object firstSegment = treeSelection.getPaths()[0].getFirstSegment();
        if (firstSegment instanceof IDockerConnection) {
            this.setConnection((IDockerConnection)firstSegment);
        }
    }
}

