/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.graph.directed.editable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.lsat.common.graph.directed.editable.Edge;
import org.eclipse.lsat.common.graph.directed.editable.EdgeTarget;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.graph.directed.editable.SourceReference;
import org.eclipse.lsat.common.queries.IterableQueries;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.common.util.BranchIterable;

public class EdgQueries {
    private EdgQueries() {
    }

    public static final QueryableIterable<Edge> getIncomingEdges(Node node) {
        return QueryableIterable.from(node.getTargetReferences()).xcollectOne(EdgeTarget::getEdge).union((Iterable)QueryableIterable.from(node.getSourceReferences()).xcollectOne(SourceReference::getEdge).xcollectOne(EdgeTarget::getEdge));
    }

    public static final QueryableIterable<Edge> getOutgoingEdges(Node node) {
        return QueryableIterable.from(node.getSourceReferences()).xcollectOne(SourceReference::getEdge);
    }

    public static final QueryableIterable<Node> directPredecessors(Node node) {
        return QueryableIterable.from((Object[])new Node[]{node}).xcollect(EdgQueries::getIncomingEdges).xcollectOne(Edge::getSourceNode);
    }

    public static final <T extends Node> Iterable<T> nearestPredecessors(Node node, Class<T> type) {
        return IterableQueries.findNearest((BranchIterable)IterableQueries.closure(Collections.singleton(node), EdgQueries::directPredecessors), type);
    }

    public static final Iterable<Node> nearestPredecessors(Node node, Predicate<? super Node> predicate) {
        return IterableQueries.findNearest((BranchIterable)IterableQueries.closure(Collections.singleton(node), EdgQueries::directPredecessors), predicate);
    }

    public static final QueryableIterable<Node> allPredecessors(Node node) {
        return QueryableIterable.from((Object[])new Node[]{node}).closure(EdgQueries::directPredecessors);
    }

    public static final QueryableIterable<Node> directSuccessors(Node node) {
        return QueryableIterable.from((Object[])new Node[]{node}).xcollect(EdgQueries::getOutgoingEdges).xcollectOne(Edge::getTargetNode);
    }

    public static final <T extends Node> Iterable<T> nearestSuccessors(Node node, Class<T> type) {
        return IterableQueries.findNearest((BranchIterable)IterableQueries.closure(Collections.singleton(node), EdgQueries::directSuccessors), type);
    }

    public static final Iterable<Node> nearestSuccessors(Node node, Predicate<? super Node> predicate) {
        return IterableQueries.findNearest((BranchIterable)IterableQueries.closure(Collections.singleton(node), EdgQueries::directSuccessors), predicate);
    }

    public static final QueryableIterable<Node> allSuccessors(Node node) {
        return QueryableIterable.from((Object[])new Node[]{node}).closure(EdgQueries::directSuccessors);
    }

    public static final <N extends Node> EList<N> topologicalOrdering(Iterable<N> nodes) {
        return EdgQueries.topologicalOrdering(nodes, new LinkedList());
    }

    public static final <N extends Node> EList<N> topologicalOrdering(Iterable<N> nodes, Comparator<? super N> preference) {
        return EdgQueries.topologicalOrdering(nodes, new PriorityQueue<N>(11, preference));
    }

    private static final <N extends Node> EList<N> topologicalOrdering(Iterable<N> nodes, Queue<N> nodesWithoutIncomingEdges) {
        assert (nodesWithoutIncomingEdges.isEmpty()) : "Expected an empty queue";
        HashMap<Node, Integer> notVisitedIncomingEdges = new HashMap<Node, Integer>();
        for (Node node : nodes) {
            int incomingEdgesSize = node.getIncomingEdges().size();
            notVisitedIncomingEdges.put(node, incomingEdgesSize);
            if (incomingEdgesSize != 0) continue;
            nodesWithoutIncomingEdges.add(node);
        }
        BasicEList topologicalOrder = new BasicEList(notVisitedIncomingEdges.size());
        while (!nodesWithoutIncomingEdges.isEmpty()) {
            Node node = (Node)nodesWithoutIncomingEdges.remove();
            topologicalOrder.add((Object)node);
            for (Edge outgoingEdge : node.getOutgoingEdges()) {
                Node sucessor = outgoingEdge.getTargetNode();
                Integer notVisitedIncomingEdgesSize = (Integer)notVisitedIncomingEdges.get(sucessor);
                if (notVisitedIncomingEdgesSize == null) continue;
                notVisitedIncomingEdgesSize = notVisitedIncomingEdgesSize - 1;
                notVisitedIncomingEdges.put(sucessor, notVisitedIncomingEdgesSize);
                if (notVisitedIncomingEdgesSize != 0) continue;
                nodesWithoutIncomingEdges.add(sucessor);
            }
        }
        if (topologicalOrder.size() != notVisitedIncomingEdges.size()) {
            return null;
        }
        return topologicalOrder;
    }

    public static final <N extends Node> List<List<Node>> pathsBetweenNodes(Node n1, Node n2) {
        ArrayList<List<Node>> result = new ArrayList<List<Node>>();
        EdgQueries.addPaths(n1, n2, result);
        return result;
    }

    private static void addPaths(Node from, Node to, List<List<Node>> result) {
        ArrayList<Edge> visited = new ArrayList<Edge>();
        ArrayList<Node> path = new ArrayList<Node>();
        path.add(from);
        EdgQueries.findAllPaths(from, to, visited, path, result);
    }

    private static void findAllPaths(Node from, Node to, List<Edge> visited, List<Node> path, List<List<Node>> result) {
        boolean start;
        boolean bl = start = path.size() == 1;
        if (!start && from.equals(to)) {
            result.add(new ArrayList<Node>(path));
            return;
        }
        for (Edge edge : from.getOutgoingEdges()) {
            if (visited.contains(edge)) continue;
            visited.add(edge);
            Node successor = edge.getTargetNode();
            path.add(successor);
            EdgQueries.findAllPaths(successor, to, visited, path, result);
            path.remove(path.size() - 1);
            visited.remove(visited.size() - 1);
        }
    }
}

