/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.lsat.common.util.ProcessingIterator;

public class UniqueIterator<E>
extends ProcessingIterator<E> {
    private final Iterator<? extends E> source;
    private final Set<? super E> cache;

    public UniqueIterator(Iterator<? extends E> source) {
        this(source, true);
    }

    public UniqueIterator(Iterator<? extends E> source, boolean useEquals) {
        this(source, useEquals ? new HashSet() : Collections.newSetFromMap(new IdentityHashMap()));
    }

    protected UniqueIterator(Iterator<? extends E> source, Set<? super E> cache) {
        this.source = source;
        this.cache = cache;
    }

    @Override
    protected boolean toNext() {
        while (this.source.hasNext()) {
            E next = this.source.next();
            if (!this.cache.add(next)) continue;
            return this.setNext(next);
        }
        return this.done();
    }
}

