/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.hover;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.internal.CancellationUtil;
import org.eclipse.lsp4e.internal.IdentifierUtil;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.operations.hover.AsyncHtmlHoverInput;
import org.eclipse.lsp4e.operations.hover.FocusableBrowserInformationControl;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public class LSPTextHover
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private static final int GET_HOVER_REGION_TIMEOUT_MS = 100;
    private @Nullable IRegion lastRegion;
    private @Nullable ITextViewer lastViewer;
    private @Nullable CompletableFuture<List<Hover>> request;
    private @Nullable CompletableFuture<@Nullable String> hoverInfoFuture;

    public @Nullable String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        this.hoverInfoFuture = this.getHoverInfoFuture(textViewer, hoverRegion);
        CompletableFuture<String> hoverInfoRequest_ = this.hoverInfoFuture;
        if (hoverInfoRequest_.isDone()) {
            try {
                return hoverInfoRequest_.getNow(null);
            }
            catch (Exception ex) {
                if (CancellationUtil.isRequestCancelledException(ex)) {
                    return null;
                }
                LanguageServerPlugin.logError(ex);
            }
        }
        return null;
    }

    public @Nullable Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        this.hoverInfoFuture = this.getHoverInfoFuture(textViewer, hoverRegion);
        CompletableFuture<String> hoverInfoRequest_ = this.hoverInfoFuture;
        String placeholder = "<html><body>Loading\u2026</body></html>";
        return new AsyncHtmlHoverInput(hoverInfoRequest_, "<html><body>Loading\u2026</body></html>");
    }

    public CompletableFuture<@Nullable String> getHoverInfoFuture(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.request == null || !textViewer.equals(this.lastViewer) || !hoverRegion.equals(this.lastRegion)) {
            this.initiateHoverRequest(textViewer, hoverRegion.getOffset());
        }
        return NullSafetyHelper.castNonNull(this.request).thenApply(hoversList -> {
            String result = hoversList.stream().filter(Objects::nonNull).map(LSPTextHover::getHoverString).filter(Objects::nonNull).collect(Collectors.joining("\n\n")).trim();
            if (!result.isEmpty()) {
                Parser parser = Parser.builder().build();
                Node document = parser.parse(result);
                HtmlRenderer renderer = HtmlRenderer.builder().build();
                return renderer.render(document);
            }
            return null;
        });
    }

    protected static @Nullable String getHoverString(Hover hover) {
        Either hoverContent = hover.getContents();
        if (hoverContent.isLeft()) {
            List contents = (List)hoverContent.getLeft();
            if (contents.isEmpty()) {
                return null;
            }
            return contents.stream().map(content -> {
                if (content.isLeft()) {
                    return (String)content.getLeft();
                }
                if (content.isRight()) {
                    MarkedString markedString = (MarkedString)content.getRight();
                    if (markedString.getLanguage() != null && !markedString.getLanguage().isEmpty()) {
                        return String.format("```%s%n%s%n```", markedString.getLanguage(), markedString.getValue());
                    }
                    return markedString.getValue();
                }
                return "";
            }).filter(((Predicate<String>)String::isEmpty).negate()).collect(Collectors.joining("\n\n"));
        }
        return ((MarkupContent)hoverContent.getRight()).getValue();
    }

    public @Nullable IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IDocument document;
        IRegion lastRegion = this.lastRegion;
        if (this.request == null || lastRegion == null || !textViewer.equals(this.lastViewer) || offset < lastRegion.getOffset() || offset > lastRegion.getOffset() + lastRegion.getLength()) {
            this.initiateHoverRequest(textViewer, offset);
        }
        if ((document = textViewer.getDocument()) == null) {
            return null;
        }
        try {
            Range range = NullSafetyHelper.castNonNull(this.request).get(100L, TimeUnit.MILLISECONDS).stream().filter(Objects::nonNull).map(Hover::getRange).filter(Objects::nonNull).reduce((first, second) -> second).get();
            int regionStartOffset = Math.max(0, LSPEclipseUtils.toOffset(range.getStart(), document));
            int regionEndOffset = Math.min(document.getLength(), LSPEclipseUtils.toOffset(range.getEnd(), document));
            this.lastRegion = new Region(regionStartOffset, regionEndOffset - regionStartOffset);
            return this.lastRegion;
        }
        catch (ExecutionException | BadLocationException e) {
            if (!CancellationUtil.isRequestCancelledException(e)) {
                LanguageServerPlugin.logError("Cannot get hover region for offset " + offset, e);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (NoSuchElementException | CancellationException | TimeoutException exception) {
            // empty catch block
        }
        this.lastRegion = LSPTextHover.computeHeuristicRegion(document, offset);
        return this.lastRegion;
    }

    private static Region computeHeuristicRegion(IDocument document, int offset) {
        try {
            return IdentifierUtil.computeIdentifierRegion(document, offset);
        }
        catch (BadLocationException ex) {
            int safeOffset = Math.max(0, Math.min(offset, document.getLength()));
            return new Region(safeOffset, 0);
        }
    }

    private void cancel() {
        if (this.request != null) {
            this.request.cancel(true);
            this.request = null;
        }
        if (this.hoverInfoFuture != null) {
            this.hoverInfoFuture.cancel(true);
            this.hoverInfoFuture = null;
        }
    }

    private void initiateHoverRequest(ITextViewer viewer, int offset) {
        this.cancel();
        IDocument document = viewer.getDocument();
        if (document == null) {
            return;
        }
        this.lastViewer = viewer;
        try {
            HoverParams params = LSPEclipseUtils.toHoverParams(offset, document);
            this.request = ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withCapability(ServerCapabilities::getHoverProvider)).collectAll(server -> server.getTextDocumentService().hover(params));
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
        }
    }

    public @Nullable IInformationControlCreator getHoverControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(Shell parent) {
                if (BrowserInformationControl.isAvailable((Composite)parent)) {
                    return new FocusableBrowserInformationControl(parent);
                }
                return new DefaultInformationControl(parent, EditorsUI.getTooltipAffordanceString());
            }
        };
    }
}

