/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.Arrays;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.ArrayIntBig;
import org.eclipse.mat.collect.ArrayLong;
import org.eclipse.mat.collect.ArrayLongBig;
import org.eclipse.mat.collect.HashMapIntLong;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.HashMapLongObject;
import org.eclipse.mat.collect.HashMapObjectLong;
import org.eclipse.mat.collect.QueueInt;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.collect.SetLong;
import org.eclipse.mat.inspections.collectionextract.AbstractExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.CollectionExtractionUtils;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

public class AbstractFillRatioQuery {
    protected void runQuantizer(IProgressListener listener, Quantize quantize, ICollectionExtractor specificExtractor, String specificClass, ISnapshot snapshot, Iterable<int[]> objects, String msg) throws SnapshotException {
        SnapshotInfo info = snapshot.getSnapshotInfo();
        int refsize = info.getIdentifierSize() == 8 && Boolean.TRUE.equals((Boolean)info.getProperty("$useCompressedOops")) ? 4 : info.getIdentifierSize();
        long LIMIT = 20L;
        HashMapIntLong exceptions = new HashMapIntLong();
        int counter = 0;
        IClass type = null;
        for (int[] objectIds : objects) {
            int objectId;
            HashMapIntObject resultMap = null;
            int[] sortedObjs = objectIds;
            int prev = Integer.MIN_VALUE;
            int[] nArray = objectIds;
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                objectId = nArray[n2];
                if (objectId < prev) {
                    sortedObjs = (int[])objectIds.clone();
                    Arrays.sort(sortedObjs);
                    resultMap = new HashMapIntObject();
                    break;
                }
                prev = objectId;
                ++n2;
            }
            nArray = sortedObjs;
            n = sortedObjs.length;
            n2 = 0;
            while (n2 < n) {
                block22: {
                    objectId = nArray[n2];
                    if (listener.isCanceled()) break;
                    IObject obj = snapshot.getObject(objectId);
                    if (counter++ % 1000 == 0 && !obj.getClazz().equals(type)) {
                        type = obj.getClazz();
                        listener.subTask(String.valueOf(msg) + "\n" + type.getName());
                    }
                    try {
                        Double fillRatio;
                        AbstractExtractedCollection<?, ?> coll = CollectionExtractionUtils.extractCollection(obj, specificClass, specificExtractor);
                        if (coll != null && coll.hasCapacity() && (fillRatio = coll.getFillRatio()) != null) {
                            Integer size;
                            long wasted = 0L;
                            if (coll.hasCapacity()) {
                                Integer c = coll.getCapacity();
                                if (c != null) {
                                    int refsize2 = obj.getClazz().getName().equals(SetInt.class.getName()) ? 4 : (obj.getClazz().getName().equals(ArrayInt.class.getName()) ? 4 : (obj.getClazz().getName().equals(QueueInt.class.getName()) ? 4 : (obj.getClazz().getName().equals(SetLong.class.getName()) ? 8 : (obj.getClazz().getName().equals(ArrayLong.class.getName()) ? 8 : (obj.getClazz().getName().equals(HashMapIntLong.class.getName()) ? 13 : (obj.getClazz().getName().equals(HashMapIntObject.class.getName()) ? 5 + refsize : (obj.getClazz().getName().equals(HashMapLongObject.class.getName()) ? 9 + refsize : (obj.getClazz().getName().equals(HashMapObjectLong.class.getName()) ? 9 + refsize : (obj.getClazz().getName().equals(ArrayIntBig.class.getName()) ? 4 : (obj.getClazz().getName().equals(ArrayLongBig.class.getName()) ? 8 : refsize))))))))));
                                    wasted = (long)((double)(c * refsize2) * (1.0 - fillRatio));
                                }
                            } else if (coll.hasExtractableArray()) {
                                IObjectArray backing = coll.extractEntries();
                                if (backing != null) {
                                    wasted = (long)((double)backing.getClazz().getHeapSizePerInstance() * (1.0 - fillRatio));
                                }
                            } else if (coll.hasSize() && (size = coll.size()) != null) {
                                int s = size;
                                if (fillRatio > 0.0) {
                                    wasted = (long)Math.min((double)(s * refsize) / (1.0 - fillRatio), (double)coll.getUsedHeapSize());
                                }
                            }
                            if (resultMap != null) {
                                resultMap.put(objectId, (Object)new Result(fillRatio, coll.getUsedHeapSize(), wasted));
                            } else {
                                quantize.addValue(objectId, new Object[]{fillRatio, 1, coll.getUsedHeapSize(), wasted});
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        int classId = obj.getClazz().getObjectId();
                        if (!exceptions.containsKey(classId)) {
                            exceptions.put(classId, 0L);
                        }
                        long c = exceptions.get(classId);
                        exceptions.put(classId, c + 1L);
                        if (c >= 20L) break block22;
                        listener.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.CollectionFillRatioQuery_IgnoringCollection, (Object[])new Object[]{obj.getTechnicalName()}), (Throwable)e);
                    }
                }
                ++n2;
            }
            if (resultMap != null) {
                nArray = objectIds;
                n = objectIds.length;
                n2 = 0;
                while (n2 < n) {
                    objectId = nArray[n2];
                    if (resultMap.containsKey(objectId)) {
                        Result r = (Result)resultMap.get(objectId);
                        quantize.addValue(objectId, new Object[]{r.fill, 1, r.used, r.wasted});
                    }
                    ++n2;
                }
            }
            if (listener.isCanceled()) break;
        }
    }

    private static class Result {
        final double fill;
        final long used;
        final long wasted;

        public Result(double fill, long used, long wasted) {
            this.fill = fill;
            this.used = used;
            this.wasted = wasted;
        }
    }
}

