/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.threads;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.IRequestDetailsResolver;
import org.eclipse.mat.snapshot.extension.IThreadDetailsResolver;
import org.eclipse.mat.snapshot.extension.IThreadInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ThreadToLocalReference;
import org.eclipse.mat.snapshot.registry.RequestDetailResolverRegistry;
import org.eclipse.mat.snapshot.registry.ThreadDetailResolverRegistry;
import org.eclipse.mat.util.IProgressListener;

class ThreadInfoImpl
implements IThreadInfo {
    public static final Column COL_CLASSNAME = new Column(Messages.Column_ClassName);
    public static final Column COL_NAME = new Column(Messages.ThreadInfoImpl_Column_Name);
    public static final Column COL_INSTANCE = new Column(Messages.ThreadStackQuery_Column_ObjectStackFrame);
    public static final Column COL_SHALLOW = new Column(Messages.Column_ShallowHeap, Bytes.class);
    public static final Column COL_RETAINED = new Column(Messages.Column_RetainedHeap, Bytes.class);
    public static final Column COL_CONTEXTCL = new Column(Messages.ThreadInfoImpl_Column_ContextClassLoader);
    public static final Column COL_ISDAEMON = new Column(Messages.ThreadInfoImpl_Column_IsDaemon, Boolean.class);
    public static final Column COL_MAXLOCALRETAINED = new Column(Messages.ThreadInfoImpl_Column_MaxLocalRetainedHeap, Bytes.class).noTotals();
    private static final List<Column> defaultColumns = Arrays.asList(COL_INSTANCE, COL_NAME, COL_SHALLOW, COL_RETAINED, COL_MAXLOCALRETAINED, COL_CONTEXTCL, COL_ISDAEMON);
    private IObject subject;
    private String name;
    private String className;
    private String instance;
    private Bytes shallowHeap = new Bytes(0L);
    private Bytes retainedHeap = new Bytes(0L);
    private String contextClassLoader;
    private int contextClassLoaderId;
    private Boolean isDaemon;
    private Map<Column, Object> properties = new HashMap<Column, Object>();
    private List<String> keywords = new ArrayList<String>();
    private CompositeResult details;
    private CompositeResult requests;

    static ThreadInfoImpl build(IObject thread, boolean readFully, IProgressListener listener) throws SnapshotException {
        ThreadInfoImpl info = new ThreadInfoImpl();
        info.subject = thread;
        ThreadInfoImpl.extractGeneralAttributes(info);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        ThreadInfoImpl.extractFromDetailsResolver(info, readFully, listener);
        if (readFully) {
            ThreadInfoImpl.extractFromRequestResolver(info, listener);
        }
        return info;
    }

    private static void extractFromRequestResolver(ThreadInfoImpl info, IProgressListener listener) throws SnapshotException {
        int[] localVars;
        ISnapshot snapshot = info.subject.getSnapshot();
        int[] nArray = localVars = ThreadInfoImpl.getLocalVarsForThread(info.subject);
        int n = localVars.length;
        int n2 = 0;
        while (n2 < n) {
            int localId = nArray[n2];
            IClass clazz = snapshot.getClassOf(localId);
            while (clazz != null) {
                IRequestDetailsResolver resolver = (IRequestDetailsResolver)RequestDetailResolverRegistry.instance().lookup(clazz.getName());
                if (resolver != null) {
                    resolver.complement(snapshot, info, localVars, localId, listener);
                    break;
                }
                clazz = clazz.getSuperClass();
            }
            ++n2;
        }
    }

    private static int[] getLocalVarsForThread(IObject thread) throws SnapshotException {
        List<NamedReference> refs = thread.getOutboundReferences();
        ArrayInt result = new ArrayInt();
        for (NamedReference ref : refs) {
            if (!(ref instanceof ThreadToLocalReference)) continue;
            result.add(ref.getObjectId());
        }
        return result.toArray();
    }

    private static void extractGeneralAttributes(ThreadInfoImpl info) throws SnapshotException {
        info.className = info.subject.getDisplayName();
        info.name = info.subject.getClassSpecificName();
        info.instance = info.subject.getTechnicalName();
        info.shallowHeap = new Bytes(info.subject.getUsedHeapSize());
        info.retainedHeap = new Bytes(info.subject.getRetainedHeapSize());
        info.isDaemon = ThreadInfoImpl.resolveIsDaemon(info.subject);
        IObject contextClassLoader = ThreadInfoImpl.resolveContextClassLoader(info);
        if (contextClassLoader != null) {
            info.contextClassLoader = contextClassLoader.getClassSpecificName();
            if (info.contextClassLoader == null) {
                info.contextClassLoader = contextClassLoader.getTechnicalName();
            }
            info.contextClassLoaderId = contextClassLoader.getObjectId();
        }
    }

    private static IObject resolveContextClassLoader(ThreadInfoImpl info) throws SnapshotException {
        try {
            IObject contextClassLoader = (IObject)info.subject.resolveValue("contextClassLoader");
            return contextClassLoader;
        }
        catch (SnapshotException snapshotException) {
            return null;
        }
    }

    private static Boolean resolveIsDaemon(IObject thread) {
        try {
            Object daemon = thread.resolveValue("daemon");
            if (daemon == null) {
                daemon = thread.resolveValue("isDaemon");
            }
            if (daemon != null && daemon instanceof Boolean) {
                return (Boolean)daemon;
            }
        }
        catch (SnapshotException snapshotException) {
            // empty catch block
        }
        return null;
    }

    private static void extractFromDetailsResolver(ThreadInfoImpl info, boolean readFully, IProgressListener listener) throws SnapshotException {
        for (IThreadDetailsResolver resolver : ThreadDetailResolverRegistry.instance().delegates()) {
            if (readFully) {
                resolver.complementDeep(info, listener);
                continue;
            }
            resolver.complementShallow(info, listener);
        }
    }

    List<Column> getUsedColumns() {
        List<Column> answer = ThreadInfoImpl.getDefaultColumnsCopy();
        for (IThreadDetailsResolver resolver : ThreadInfoImpl.sortedResolvers()) {
            Column[] cols = resolver.getColumns();
            if (cols == null) continue;
            int ii = 0;
            while (ii < cols.length) {
                if (this.properties.containsKey(cols[ii]) && !answer.contains(cols[ii])) {
                    answer.add(cols[ii]);
                }
                ++ii;
            }
        }
        return answer;
    }

    static List<Column> getUsedColumns(List<ThreadInfoImpl> threads) {
        List<Column> answer = ThreadInfoImpl.getDefaultColumnsCopy();
        for (IThreadDetailsResolver resolver : ThreadInfoImpl.sortedResolvers()) {
            Column[] cols = resolver.getColumns();
            if (cols == null) continue;
            int ii = 0;
            while (ii < cols.length) {
                for (ThreadInfoImpl thread : threads) {
                    if (!thread.properties.containsKey(cols[ii]) || answer.contains(cols[ii])) continue;
                    answer.add(cols[ii]);
                    break;
                }
                ++ii;
            }
        }
        return answer;
    }

    private static List<Column> getDefaultColumnsCopy() {
        ArrayList<Column> answer = new ArrayList<Column>();
        for (Column col : defaultColumns) {
            Column col2 = new Column(col.getLabel(), col.getType(), col.getAlign(), col.getSortDirection(), col.getFormatter(), col.getComparator());
            if (!col.getCalculateTotals()) {
                col2.noTotals();
            }
            answer.add(col2);
        }
        return answer;
    }

    private static List<IThreadDetailsResolver> sortedResolvers() {
        Collection delegates = ThreadDetailResolverRegistry.instance().delegates();
        ArrayList<IThreadDetailsResolver> delegates2 = new ArrayList<IThreadDetailsResolver>(delegates);
        Collections.sort(delegates2, new CompResolver());
        return delegates2;
    }

    private ThreadInfoImpl() {
    }

    @Override
    public IObject getThreadObject() {
        return this.subject;
    }

    @Override
    public int getThreadId() {
        return this.subject.getObjectId();
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getInstance() {
        return this.instance;
    }

    public Bytes getShallowHeap() {
        return this.shallowHeap;
    }

    public Bytes getRetainedHeap() {
        return this.retainedHeap;
    }

    public String getContextClassLoader() {
        return this.contextClassLoader;
    }

    @Override
    public int getContextClassLoaderId() {
        return this.contextClassLoaderId;
    }

    @Override
    public void addDetails(String name, IResult detail) {
        if (this.details == null) {
            this.details = new CompositeResult(new IResult[0]);
        }
        this.details.addResult(name, detail);
    }

    public CompositeResult getDetails() {
        return this.details;
    }

    @Override
    public void addKeyword(String keyword) {
        this.keywords.add(keyword);
    }

    @Override
    public Collection<String> getKeywords() {
        return this.keywords;
    }

    @Override
    public void setValue(Column column, Object value) {
        this.properties.put(column, value);
    }

    @Override
    public void addRequest(String summary, IResult detail) {
        if (this.requests == null) {
            this.requests = new CompositeResult(new IResult[0]);
        }
        this.requests.addResult(summary, detail);
    }

    @Override
    public CompositeResult getRequests() {
        return this.requests;
    }

    private Object isDaemon() {
        return this.isDaemon;
    }

    public Object getValue(Column column) {
        if (COL_CLASSNAME.equals((Object)column)) {
            return this.getClassName();
        }
        if (COL_NAME.equals((Object)column)) {
            return this.getName();
        }
        if (COL_INSTANCE.equals((Object)column)) {
            return this.getInstance();
        }
        if (COL_SHALLOW.equals((Object)column)) {
            return this.getShallowHeap();
        }
        if (COL_RETAINED.equals((Object)column)) {
            return this.getRetainedHeap();
        }
        if (COL_CONTEXTCL.equals((Object)column)) {
            return this.getContextClassLoader();
        }
        if (COL_ISDAEMON.equals((Object)column)) {
            return this.isDaemon();
        }
        if (COL_MAXLOCALRETAINED.equals((Object)column)) {
            return null;
        }
        return this.properties.get(column);
    }

    private static final class CompResolver
    implements Comparator<IThreadDetailsResolver>,
    Serializable {
        private CompResolver() {
        }

        @Override
        public int compare(IThreadDetailsResolver o1, IThreadDetailsResolver o2) {
            String n2;
            ClassLoader l1 = o1.getClass().getClassLoader();
            ClassLoader l2 = o2.getClass().getClassLoader();
            if (l1 == null) {
                if (l2 != null) {
                    return -1;
                }
                return 0;
            }
            if (l2 == null) {
                return 1;
            }
            String n1 = l1.toString().replaceFirst("[^\\[]*", "");
            int r = n1.compareTo(n2 = l2.toString().replaceFirst("[^\\[]*", ""));
            if (r != 0) {
                return r;
            }
            return o1.getClass().getName().compareTo(o2.getClass().getName());
        }
    }
}

