/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum UnitsOfMeasurement implements Enumerator
{
    PIXELS_LITERAL(0, "Pixels", "Pixels"),
    POINTS_LITERAL(1, "Points", "Points"),
    INCHES_LITERAL(2, "Inches", "Inches"),
    CENTIMETERS_LITERAL(3, "Centimeters", "Centimeters");

    public static final int PIXELS = 0;
    public static final int POINTS = 1;
    public static final int INCHES = 2;
    public static final int CENTIMETERS = 3;
    private static final UnitsOfMeasurement[] VALUES_ARRAY;
    public static final List<UnitsOfMeasurement> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UnitsOfMeasurement[]{PIXELS_LITERAL, POINTS_LITERAL, INCHES_LITERAL, CENTIMETERS_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UnitsOfMeasurement get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnitsOfMeasurement result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnitsOfMeasurement getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnitsOfMeasurement result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnitsOfMeasurement get(int value) {
        switch (value) {
            case 0: {
                return PIXELS_LITERAL;
            }
            case 1: {
                return POINTS_LITERAL;
            }
            case 2: {
                return INCHES_LITERAL;
            }
            case 3: {
                return CENTIMETERS_LITERAL;
            }
        }
        return null;
    }

    private UnitsOfMeasurement(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

