/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.metrics.tck.application.cdi;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import org.eclipse.microprofile.telemetry.metrics.tck.application.TestLibraries;
import org.eclipse.microprofile.telemetry.metrics.tck.application.TestUtils;
import org.eclipse.microprofile.telemetry.metrics.tck.application.exporter.InMemoryMetricExporter;
import org.eclipse.microprofile.telemetry.metrics.tck.application.exporter.InMemoryMetricExporterProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DoubleHistogramTest
extends Arquillian {
    private static final String histogramName = "testDoubleHistogram";
    private static final String histogramDescription = "Testing double histogram";
    private static final String histogramUnit = "Metric Tonnes";
    private static final double DOUBLE_WITH_ATTRIBUTES = 20.0;
    private static final double DOUBLE_WITHOUT_ATTRIBUTES = 10.0;
    @Inject
    private Meter sdkMeter;
    @Inject
    private InMemoryMetricExporter metricExporter;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{InMemoryMetricExporter.class, InMemoryMetricExporterProvider.class, TestUtils.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addAsServiceProvider(ConfigurableMetricExporterProvider.class, new Class[]{InMemoryMetricExporterProvider.class})).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false\notel.metrics.exporter=in-memory\notel.logs.exporter=none\notel.traces.exporter=none\notel.metric.export.interval=3000"), "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeMethod
    void setUp() {
        if (this.metricExporter != null) {
            this.metricExporter.reset();
        }
    }

    @Test
    void testDoubleHistogram() throws InterruptedException {
        DoubleHistogram doubleHistogram = this.sdkMeter.histogramBuilder(histogramName).setDescription(histogramDescription).setUnit(histogramUnit).build();
        Assert.assertNotNull((Object)doubleHistogram);
        HashMap<Double, Attributes> expectedResults = new HashMap<Double, Attributes>();
        expectedResults.put(20.0, Attributes.builder().put("K", "V").build());
        expectedResults.put(10.0, Attributes.empty());
        expectedResults.keySet().stream().forEach(key -> doubleHistogram.record(key.doubleValue(), (Attributes)expectedResults.get(key)));
        List<MetricData> metrics = this.metricExporter.getMetricData(histogramName);
        metrics.stream().peek(metricData -> {
            Assert.assertEquals((Object)metricData.getType(), (Object)MetricDataType.HISTOGRAM);
            Assert.assertEquals((String)metricData.getDescription(), (String)histogramDescription);
            Assert.assertEquals((String)metricData.getUnit(), (String)histogramUnit);
        }).flatMap(metricData -> metricData.getHistogramData().getPoints().stream()).forEach(point -> {
            Assert.assertTrue((boolean)expectedResults.containsKey(point.getSum()), (String)("Double " + point.getSum() + " was not an expected result"));
            Assert.assertTrue((boolean)point.getAttributes().equals(expectedResults.get(point.getSum())), (String)("Attributes were not equal." + System.lineSeparator() + "Actual values: " + TestUtils.mapToString(point.getAttributes().asMap()) + System.lineSeparator() + "Expected values: " + TestUtils.mapToString(((Attributes)expectedResults.get(point.getSum())).asMap())));
        });
    }
}

