/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.async;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import jakarta.inject.Inject;
import java.net.URL;
import java.util.List;
import org.eclipse.microprofile.telemetry.tracing.tck.BasicHttpClient;
import org.eclipse.microprofile.telemetry.tracing.tck.ConfigAsset;
import org.eclipse.microprofile.telemetry.tracing.tck.TestLibraries;
import org.eclipse.microprofile.telemetry.tracing.tck.async.JaxRsClientAsyncTestEndpoint;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporter;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporterProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JaxRsClientAsyncTest
extends Arquillian {
    private BasicHttpClient basicClient;
    @ArquillianResource
    private URL url;
    public static final String TEST_PASSED = "Test Passed";
    public static final String QUERY_VALUE = "bar";
    @Inject
    private InMemorySpanExporter spanExporter;

    @Deployment
    public static WebArchive createDeployment() {
        ConfigAsset config = new ConfigAsset().add("otel.bsp.schedule.delay", "100").add("otel.sdk.disabled", "false").add("otel.metrics.exporter", "none").add("otel.traces.exporter", "in-memory");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{InMemorySpanExporter.class, InMemorySpanExporterProvider.class, BasicHttpClient.class, JaxRsClientAsyncTestEndpoint.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addAsServiceProvider(ConfigurableSpanExporterProvider.class, new Class[]{InMemorySpanExporterProvider.class})).addAsResource((Asset)config, "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeMethod
    void setUp() {
        if (this.spanExporter != null) {
            this.spanExporter.reset();
            this.basicClient = new BasicHttpClient(this.url);
        }
    }

    @Test
    public void testIntegrationWithJaxRsClient() throws Exception {
        this.basicClient.get("/JaxRsClientAsyncTestEndpoint/jaxrsclient?baggageValue=bar");
        this.readSpans();
    }

    @Test
    public void testIntegrationWithJaxRsClientAsync() throws Exception {
        this.basicClient.get("/JaxRsClientAsyncTestEndpoint/jaxrsclientasync?baggageValue=bar");
        this.readSpans();
    }

    @Test
    public void testIntegrationWithJaxRsClientError() throws Exception {
        this.basicClient.get("/JaxRsClientAsyncTestEndpoint/jaxrsclienterror");
        this.readErrorSpans();
    }

    public void readErrorSpans() {
        this.spanExporter.assertSpanCount(3);
        List<SpanData> serverSpans = this.spanExporter.getSpansWithKind(SpanKind.SERVER);
        SpanData firstURL = null;
        SpanData secondURL = null;
        for (SpanData span : serverSpans) {
            if (((String)span.getAttributes().get(UrlAttributes.URL_PATH)).contains("JaxRsClientAsyncTestEndpoint/jaxrsclient")) {
                firstURL = span;
                continue;
            }
            secondURL = span;
        }
        Assert.assertNotNull(firstURL);
        Assert.assertNotNull(secondURL);
        SpanData httpGet = this.spanExporter.getFirst(SpanKind.CLIENT);
        Assert.assertEquals((String)httpGet.getSpanId(), (String)secondURL.getParentSpanId());
        Assert.assertEquals((String)firstURL.getSpanId(), (String)httpGet.getParentSpanId());
        Assert.assertEquals((String)((String)firstURL.getAttributes().get(HttpAttributes.HTTP_REQUEST_METHOD)), (String)"GET");
        Assert.assertEquals((String)((String)firstURL.getAttributes().get(UrlAttributes.URL_SCHEME)), (String)"http");
        Assert.assertEquals((int)((Long)secondURL.getAttributes().get(HttpAttributes.HTTP_RESPONSE_STATUS_CODE)).intValue(), (int)400);
        Assert.assertEquals((int)((Long)httpGet.getAttributes().get(HttpAttributes.HTTP_RESPONSE_STATUS_CODE)).intValue(), (int)400);
        Assert.assertEquals((int)((Long)firstURL.getAttributes().get(HttpAttributes.HTTP_RESPONSE_STATUS_CODE)).intValue(), (int)200);
        Assert.assertTrue((boolean)((String)httpGet.getAttributes().get(UrlAttributes.URL_FULL)).contains("JaxRsClientAsyncTestEndpoint"));
        Assert.assertEquals((String)((String)httpGet.getAttributes().get(HttpAttributes.HTTP_REQUEST_METHOD)), (String)"GET");
        Assert.assertTrue((boolean)((String)httpGet.getAttributes().get(UrlAttributes.URL_FULL)).contains("JaxRsClientAsyncTestEndpoint"));
    }

    public void readSpans() {
        this.spanExporter.assertSpanCount(3);
        List<SpanData> serverSpans = this.spanExporter.getSpansWithKind(SpanKind.SERVER);
        SpanData firstURL = null;
        SpanData secondURL = null;
        for (SpanData span : serverSpans) {
            if (((String)span.getAttributes().get(UrlAttributes.URL_PATH)).contains("JaxRsClientAsyncTestEndpoint/jaxrsclient")) {
                firstURL = span;
                continue;
            }
            secondURL = span;
        }
        Assert.assertNotNull(firstURL);
        Assert.assertNotNull(secondURL);
        SpanData httpGet = this.spanExporter.getFirst(SpanKind.CLIENT);
        Assert.assertEquals((String)httpGet.getSpanId(), (String)secondURL.getParentSpanId());
        Assert.assertEquals((String)firstURL.getSpanId(), (String)httpGet.getParentSpanId());
        Assert.assertEquals((int)((Long)firstURL.getAttributes().get(HttpAttributes.HTTP_RESPONSE_STATUS_CODE)).intValue(), (int)200);
        Assert.assertEquals((String)((String)firstURL.getAttributes().get(HttpAttributes.HTTP_REQUEST_METHOD)), (String)"GET");
        Assert.assertEquals((String)((String)firstURL.getAttributes().get(UrlAttributes.URL_SCHEME)), (String)"http");
        Assert.assertTrue((boolean)((String)firstURL.getAttributes().get(UrlAttributes.URL_QUERY)).contains(QUERY_VALUE));
        Assert.assertTrue((boolean)((String)httpGet.getAttributes().get(UrlAttributes.URL_FULL)).contains("JaxRsClientAsyncTestEndpoint"));
        Assert.assertEquals((int)((Long)httpGet.getAttributes().get(HttpAttributes.HTTP_RESPONSE_STATUS_CODE)).intValue(), (int)200);
        Assert.assertEquals((String)((String)httpGet.getAttributes().get(HttpAttributes.HTTP_REQUEST_METHOD)), (String)"GET");
        Assert.assertTrue((boolean)((String)httpGet.getAttributes().get(UrlAttributes.URL_FULL)).contains("JaxRsClientAsyncTestEndpoint"));
    }
}

