/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.IListIndexAffecting;
import org.eclipse.emf.cdo.internal.common.revision.delta.IListTargetAdding;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CDORemoveFeatureDeltaImpl
extends CDOFeatureDeltaImpl
implements CDORemoveFeatureDelta,
IListIndexAffecting {
    private int index;

    public CDORemoveFeatureDeltaImpl(EStructuralFeature feature, int index) {
        super(feature);
        this.index = index;
    }

    public CDORemoveFeatureDeltaImpl(CDODataInput in, EClass eClass) throws IOException {
        super(in, eClass);
        this.index = in.readInt();
    }

    public void write(CDODataOutput out, EClass eClass) throws IOException {
        super.write(out, eClass);
        out.writeInt(this.index);
    }

    public int getIndex() {
        return this.index;
    }

    public CDOFeatureDelta.Type getType() {
        return CDOFeatureDelta.Type.REMOVE;
    }

    public void apply(CDORevision revision) {
        ((InternalCDORevision)revision).getList(this.getFeature()).remove(this.index);
    }

    public void accept(CDOFeatureDeltaVisitor visitor) {
        visitor.visit(this);
    }

    public void affectIndices(IListTargetAdding[] sources, int[] indices) {
        int index = this.getIndex();
        int i = 1;
        while (i <= indices[0]) {
            if (indices[i] > index) {
                int n = i;
                indices[n] = indices[n] - 1;
            } else if (indices[i] == index) {
                int n = indices[0];
                indices[0] = n - 1;
                int rest = n - i;
                if (rest > 0) {
                    System.arraycopy(indices, i + 1, indices, i, rest);
                    System.arraycopy(sources, i + 1, sources, i, rest);
                    --i;
                }
            }
            ++i;
        }
    }

    public void adjustReferences(CDOReferenceAdjuster idMappings) {
    }
}

