/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.defs;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ResourceMode implements Enumerator
{
    GET(0, "GET", "GET"){

        public CDOResource getResource(String path, CDOTransaction transaction) {
            return transaction.getResource(path);
        }
    }
    ,
    CREATE(0, "CREATE", "CREATE"){

        public CDOResource getResource(String path, CDOTransaction transaction) {
            return transaction.createResource(path);
        }
    }
    ,
    GET_OR_CREATE(0, "GET_OR_CREATE", "GET_OR_CREATE"){

        public CDOResource getResource(String path, CDOTransaction transaction) {
            return transaction.getOrCreateResource(path);
        }
    };

    public static final int GET_VALUE = 0;
    public static final int CREATE_VALUE = 0;
    public static final int GET_OR_CREATE_VALUE = 0;
    private static final ResourceMode[] VALUES_ARRAY;
    public static final List<ResourceMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ResourceMode[]{GET, CREATE, GET_OR_CREATE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ResourceMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResourceMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResourceMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResourceMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResourceMode get(int value) {
        switch (value) {
            case 0: {
                return GET;
            }
        }
        return null;
    }

    private ResourceMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public CDOResource getResource(String path, CDOTransaction cdoTransaction) {
        throw new UnsupportedOperationException("use a subclass!");
    }

    /* synthetic */ ResourceMode(String string, int n, int n2, String string2, String string3, ResourceMode resourceMode) {
        this(n2, string2, string3);
    }
}

