/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.hibernate.IHibernateMappingProvider;
import org.eclipse.emf.cdo.server.hibernate.IHibernateStore;
import org.eclipse.emf.cdo.server.hibernate.id.CDOIDHibernate;
import org.eclipse.emf.cdo.server.internal.hibernate.FileHibernateMappingProvider;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateCommitContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreAccessor;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateThreadContext;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.hibernate.Session;

public class HibernateUtil {
    private static final String EXT_POINT = "mappingProviderFactories";
    private static HibernateUtil instance = new HibernateUtil();
    private static String SEPARATOR = "_;_";

    public static HibernateUtil getInstance() {
        return instance;
    }

    public static void setInstance(HibernateUtil instance) {
        HibernateUtil.instance = instance;
    }

    public IHibernateStore createStore(IHibernateMappingProvider mappingProvider) {
        HibernateStore store = new HibernateStore(mappingProvider);
        mappingProvider.setHibernateStore(store);
        return store;
    }

    public IHibernateMappingProvider.Factory createMappingProviderFactory(String type) {
        IConfigurationElement[] elements;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.emf.cdo.server.hibernate", EXT_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String typeAttr;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("mappingProviderFactory".equals(element.getName()) && ObjectUtil.equals((Object)(typeAttr = element.getAttribute("type")), (Object)type)) {
                try {
                    return (IHibernateMappingProvider.Factory)element.createExecutableExtension("class");
                }
                catch (CoreException ex) {
                    throw WrappedException.wrap((Exception)((Object)ex));
                }
            }
            ++n2;
        }
        return null;
    }

    public IHibernateMappingProvider createFileMappingProvider(String ... locations) {
        return new FileHibernateMappingProvider(locations);
    }

    public Session getHibernateSession() {
        HibernateStoreAccessor accessor = HibernateThreadContext.getCurrentHibernateStoreAccessor();
        return accessor.getHibernateSession();
    }

    public Properties getPropertiesFromStore(IStore store) {
        Properties props = new Properties();
        Map storeProps = store.getRepository().getProperties();
        for (String key : storeProps.keySet()) {
            props.setProperty(key, (String)storeProps.get(key));
        }
        return props;
    }

    public String getEntityName(CDORevision cdoRevision) {
        return cdoRevision.getEClass().getName();
    }

    public CDOIDHibernate getCDOIDHibernate(CDOID cdoID) {
        InternalCDORevision cdoRevision = this.getCDORevision(cdoID);
        if (cdoRevision.getID() instanceof CDOIDHibernate) {
            return (CDOIDHibernate)cdoRevision.getID();
        }
        Session session = this.getHibernateSession();
        if (!(cdoRevision.getID() instanceof CDOIDHibernate)) {
            session.saveOrUpdate((Object)cdoRevision);
        }
        if (!(cdoRevision.getID() instanceof CDOIDHibernate)) {
            throw new IllegalStateException("CDORevision " + cdoRevision.getEClass().getName() + " " + cdoRevision.getID() + " does not have a hibernate cdoid after saving/updating it");
        }
        return (CDOIDHibernate)cdoRevision.getID();
    }

    public InternalCDORevision getCDORevision(Object target) {
        return (InternalCDORevision)target;
    }

    public InternalCDORevision getCDORevision(CDOID id) {
        if (CDOIDUtil.isNull((CDOID)id)) {
            return null;
        }
        if (HibernateThreadContext.isHibernateCommitContextSet()) {
            CDOID newID;
            HibernateCommitContext hcc = HibernateThreadContext.getHibernateCommitContext();
            InternalCDORevision revision = hcc.getDirtyObject(id);
            if (revision != null) {
                return revision;
            }
            revision = hcc.getNewObject(id);
            if (revision != null) {
                return revision;
            }
            if (id instanceof CDOIDTemp && (newID = (CDOID)hcc.getCommitContext().getIDMappings().get(id)) != null) {
                return this.getCDORevision(newID);
            }
        }
        if (!(id instanceof CDOIDHibernate)) {
            throw new IllegalArgumentException("Passed cdoid is not an instance of CDOIDHibernate but a " + id.getClass().getName() + ": " + id);
        }
        CDOIDHibernate cdoIDHibernate = (CDOIDHibernate)id;
        Session session = this.getHibernateSession();
        return (InternalCDORevision)session.get(cdoIDHibernate.getEntityName(), cdoIDHibernate.getId());
    }

    public InternalCDORevision getCDORevisionNullable(CDOID id) {
        if (CDOIDUtil.isNull((CDOID)id)) {
            return null;
        }
        if (HibernateThreadContext.isHibernateCommitContextSet()) {
            CDOID newID;
            HibernateCommitContext hcc = HibernateThreadContext.getHibernateCommitContext();
            InternalCDORevision revision = hcc.getDirtyObject(id);
            if (revision != null) {
                return revision;
            }
            revision = hcc.getNewObject(id);
            if (revision != null) {
                return revision;
            }
            if (id instanceof CDOIDTemp && (newID = (CDOID)hcc.getCommitContext().getIDMappings().get(id)) != null) {
                return this.getCDORevision(newID);
            }
        }
        if (!(id instanceof CDOIDHibernate)) {
            return null;
        }
        CDOIDHibernate cdoIDHibernate = (CDOIDHibernate)id;
        Session session = this.getHibernateSession();
        return (InternalCDORevision)session.get(cdoIDHibernate.getEntityName(), cdoIDHibernate.getId());
    }

    public int convertStringToFeatureID(EObject contained, String value) {
        String[] values = value.split(SEPARATOR);
        String nsuri = values[0];
        EPackage eContainerPackage = EPackage.Registry.INSTANCE.getEPackage(nsuri);
        String eContainerEClassName = values[1];
        EClass eContainingClass = (EClass)eContainerPackage.getEClassifier(eContainerEClassName);
        EPackage eFeaturePackage = EPackage.Registry.INSTANCE.getEPackage(values[2]);
        String eClassifierName = values[3];
        EClassifier eClassifier = eFeaturePackage.getEClassifier(eClassifierName);
        EClass eFeatureClass = (EClass)eClassifier;
        String eFeatureName = values[4];
        EStructuralFeature eFeature = eFeatureClass.getEStructuralFeature(eFeatureName);
        return this.getContainerFeatureId(eContainingClass, contained, eFeature);
    }

    private int getContainerFeatureId(EClass containingEClass, EObject contained, EStructuralFeature eFeature) {
        if (eFeature instanceof EAttribute) {
            return -1 - containingEClass.getFeatureID(eFeature);
        }
        EReference eReference = (EReference)eFeature;
        if (eReference.getEOpposite() != null) {
            EReference containerEReference = eReference.getEOpposite();
            return contained.eClass().getFeatureID((EStructuralFeature)containerEReference);
        }
        return -1 - containingEClass.getFeatureID((EStructuralFeature)eReference);
    }

    public static String convertEContainerRelationToString(EClass eClass, EStructuralFeature eFeature) {
        StringBuilder result = new StringBuilder();
        String uri = eClass.getEPackage().getNsURI();
        String eClassifierName = eClass.getName();
        result.append(String.valueOf(uri) + SEPARATOR + eClassifierName);
        uri = eFeature.getEContainingClass().getEPackage().getNsURI();
        String eClassName = eFeature.getEContainingClass().getName();
        String eFeatureName = eFeature.getName();
        result.append(String.valueOf(SEPARATOR) + uri + SEPARATOR + eClassName + SEPARATOR + eFeatureName);
        return result.toString();
    }
}

