/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate.tuplizer;

import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStore;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOContainerIDGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOContainerIDSetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOContainingFeatureIDGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOContainingFeatureIDSetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOIDPropertyGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOIDPropertySetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOManyReferenceGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOManyReferenceSetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOPropertyGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOPropertySetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOReferenceGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOReferenceSetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOResourceIDGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOResourceIDSetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDORevisionInstantiator;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDORevisionProxyFactory;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOVersionPropertyGetter;
import org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOVersionPropertySetter;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.entity.AbstractEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;

public class CDORevisionTuplizer
extends AbstractEntityTuplizer {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, CDORevisionTuplizer.class);
    private EClass eClass;

    public CDORevisionTuplizer(EntityMetamodel entityMetamodel, PersistentClass mappingInfo) {
        super(entityMetamodel, mappingInfo);
        if (TRACER.isEnabled()) {
            TRACER.trace("Created CDORevisionTuplizer for entity " + mappingInfo.getEntityName());
        }
        this.initEClass(mappingInfo);
    }

    private void initEClass(PersistentClass mappingInfo) {
        if (this.eClass != null) {
            return;
        }
        HibernateStore hbStore = HibernateStore.getCurrentHibernateStore();
        String entityName = mappingInfo.getEntityName();
        String ePackageURI = mappingInfo.getMetaAttribute("epackage").getValue();
        if (TRACER.isEnabled()) {
            TRACER.trace("EntityName/packageURI " + entityName + " " + ePackageURI);
        }
        block0: for (EPackage ePackage : hbStore.getPackageHandler().getEPackages()) {
            if (ePackage.getNsURI().compareTo(ePackageURI) != 0) continue;
            EClass[] eClassArray = EMFUtil.getPersistentClasses((EPackage)ePackage);
            int n = eClassArray.length;
            int n2 = 0;
            while (n2 < n) {
                EClass localCdoClass = eClassArray[n2];
                if (localCdoClass.getName().compareTo(entityName) == 0) {
                    this.eClass = localCdoClass;
                    continue block0;
                }
                ++n2;
            }
        }
        if (this.eClass == null && ePackageURI.compareTo(EresourcePackage.eINSTANCE.getNsURI()) == 0) {
            EClass[] eClassArray = EMFUtil.getPersistentClasses((EPackage)EresourcePackage.eINSTANCE);
            int n = eClassArray.length;
            int n3 = 0;
            while (n3 < n) {
                EClass localCdoClass = eClassArray[n3];
                if (localCdoClass.getName().compareTo(entityName) == 0) {
                    this.eClass = localCdoClass;
                    if (!TRACER.isEnabled()) break;
                    TRACER.trace("Class is CDOResource class");
                    break;
                }
                ++n3;
            }
        }
        if (this.eClass == null) {
            throw new IllegalArgumentException("The mapped class " + mappingInfo.getEntityName() + " does not have a eClass equivalent");
        }
    }

    public EntityMode getEntityMode() {
        return EntityMode.MAP;
    }

    public EClass getEClass() {
        return this.eClass;
    }

    protected Getter buildPropertyGetter(Property mappedProperty, PersistentClass mappedEntity) {
        this.initEClass(mappedEntity);
        if (TRACER.isEnabled()) {
            TRACER.trace("Building property getter for " + this.eClass.getName() + "." + mappedProperty.getName());
        }
        if (mappedProperty.isBackRef()) {
            return mappedProperty.getGetter(mappedEntity.getMappedClass());
        }
        if (mappedProperty == mappedEntity.getIdentifierProperty()) {
            return new CDOIDPropertyGetter(this, mappedProperty.getName());
        }
        if (mappedProperty == mappedEntity.getVersion()) {
            return new CDOVersionPropertyGetter(this, mappedProperty.getName());
        }
        if (mappedProperty.getName().compareTo("resourceID") == 0) {
            return new CDOResourceIDGetter(this, mappedProperty.getName());
        }
        if (mappedProperty.getName().compareTo("containerID") == 0) {
            return new CDOContainerIDGetter(this, mappedProperty.getName());
        }
        if (mappedProperty.getName().compareTo("containingFeatureID") == 0) {
            return new CDOContainingFeatureIDGetter(this, mappedProperty.getName());
        }
        if (mappedProperty.getName().compareTo("containingFeatureName") == 0) {
            return new CDOContainingFeatureIDGetter(this, mappedProperty.getName());
        }
        EStructuralFeature feature = this.getEClass().getEStructuralFeature(mappedProperty.getName());
        if (feature instanceof EReference && feature.isMany()) {
            return new CDOManyReferenceGetter(this, mappedProperty.getName());
        }
        if (feature instanceof EReference) {
            return new CDOReferenceGetter(this, mappedProperty.getName());
        }
        return new CDOPropertyGetter(this, mappedProperty.getName());
    }

    protected Setter buildPropertySetter(Property mappedProperty, PersistentClass mappedEntity) {
        this.initEClass(mappedEntity);
        if (TRACER.isEnabled()) {
            TRACER.trace("Building property setter for " + this.eClass.getName() + "." + mappedProperty.getName());
        }
        if (mappedProperty.isBackRef()) {
            return mappedProperty.getSetter(mappedEntity.getMappedClass());
        }
        if (mappedProperty == mappedEntity.getIdentifierProperty()) {
            return new CDOIDPropertySetter(this, mappedProperty.getName());
        }
        if (mappedProperty == mappedEntity.getVersion()) {
            return new CDOVersionPropertySetter(this, mappedProperty.getName());
        }
        if (mappedProperty.getName().compareTo("resourceID") == 0) {
            return new CDOResourceIDSetter(this, mappedProperty.getName());
        }
        if (mappedProperty.getName().compareTo("containerID") == 0) {
            return new CDOContainerIDSetter(this, mappedProperty.getName());
        }
        if (mappedProperty.getName().compareTo("containingFeatureID") == 0) {
            return new CDOContainingFeatureIDSetter(this, mappedProperty.getName());
        }
        if (mappedProperty.getName().compareTo("containingFeatureName") == 0) {
            return new CDOContainingFeatureIDSetter(this, mappedProperty.getName());
        }
        EStructuralFeature feature = this.getEClass().getEStructuralFeature(mappedProperty.getName());
        if (feature instanceof EReference && feature.isMany()) {
            return new CDOManyReferenceSetter(this, mappedProperty.getName());
        }
        if (feature instanceof EReference) {
            return new CDOReferenceSetter(this, mappedProperty.getName());
        }
        return new CDOPropertySetter(this, mappedProperty.getName());
    }

    protected Instantiator buildInstantiator(PersistentClass mappingInfo) {
        return new CDORevisionInstantiator(this, mappingInfo);
    }

    protected ProxyFactory buildProxyFactory(PersistentClass mappingInfo, Getter idGetter, Setter idSetter) {
        CDORevisionProxyFactory pf = new CDORevisionProxyFactory();
        try {
            pf.postInstantiate(this.getEntityName(), null, null, null, null, null);
        }
        catch (HibernateException ex) {
            OM.LOG.error("Could not create proxy factory for " + this.getEntityName(), (Throwable)ex);
            pf = null;
        }
        return pf;
    }

    public Class getMappedClass() {
        return InternalCDORevision.class;
    }

    public Class getConcreteProxyClass() {
        return InternalCDORevision.class;
    }

    public boolean isInstrumented() {
        return false;
    }
}

