/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.common.util.CDOQueryQueue;
import org.eclipse.emf.cdo.internal.common.CDOQueryInfoImpl;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.internal.cdo.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.spi.cdo.AbstractQueryIterator;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryRequest
extends CDOClientRequest<List<Object>> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, QueryRequest.class);
    private int viewID;
    private AbstractQueryIterator<?> queryResult;

    public QueryRequest(CDOClientProtocol protocol, int viewID, AbstractQueryIterator<?> queryResult) {
        super(protocol, (short)18);
        this.viewID = viewID;
        this.queryResult = queryResult;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeInt(this.viewID);
        ((CDOQueryInfoImpl)this.queryResult.getQueryInfo()).write(out);
    }

    @Override
    protected List<Object> confirming(CDODataInput in) throws IOException {
        int queryID = in.readInt();
        this.queryResult.setQueryID(queryID);
        CDOQueryQueue resultQueue = this.queryResult.getQueue();
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            try {
                int numberOfObjectsReceived = 0;
                while (in.readBoolean()) {
                    Object element = in.readCDORevisionOrPrimitive();
                    resultQueue.add(element);
                    ++numberOfObjectsReceived;
                }
                if (TRACER.isEnabled()) {
                    TRACER.format("Query executed [{0} elements received]", new Object[]{numberOfObjectsReceived});
                }
            }
            catch (RuntimeException ex) {
                resultQueue.setException((Throwable)ex);
                resultQueue.close();
            }
            catch (Throwable throwable) {
                resultQueue.setException((Throwable)new RuntimeException(throwable.getMessage(), throwable));
                resultQueue.close();
            }
        }
        finally {
            resultQueue.close();
        }
        return result;
    }
}

