/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.diff.engine.IDiffEngine;
import org.eclipse.emf.compare.diff.internal.service.DefaultDiffEngineSelector;
import org.eclipse.emf.compare.diff.internal.service.DiffExtensionDescriptor;
import org.eclipse.emf.compare.diff.metamodel.AbstractDiffExtension;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DiffResourceSet;
import org.eclipse.emf.compare.diff.metamodel.ResourceDependencyChange;
import org.eclipse.emf.compare.diff.service.DiffEngineDescriptor;
import org.eclipse.emf.compare.diff.service.DiffEngineRegistry;
import org.eclipse.emf.compare.diff.service.IDiffEngineSelector;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.MatchResourceSet;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.compare.match.metamodel.UnmatchModel;
import org.eclipse.emf.compare.util.EMFCompareMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiffService {
    private static final String ALL_EXTENSIONS = "*";
    private static final String DEFAULT_EXTENSION = "ecore";
    private static final Map<String, ArrayList<DiffExtensionDescriptor>> PARSED_DIFF_EXTENSIONS = new EMFCompareMap();
    private static final String DIFF_EXTENSION_EXTENSION_POINT = "org.eclipse.emf.compare.diff.extension";
    private static final String TAG_DIFF_EXTENSION = "diffExtension";
    private static IDiffEngineSelector diffEngineSelector = new DefaultDiffEngineSelector();

    static {
        DiffService.parseExtensionMetadata();
    }

    private DiffService() {
    }

    public static DiffModel doDiff(MatchModel match) {
        return DiffService.doDiff(match, false);
    }

    public static DiffModel doDiff(MatchModel match, boolean threeWay) {
        String extension = DEFAULT_EXTENSION;
        if (!match.getLeftRoots().isEmpty() && ((EObject)match.getLeftRoots().get(0)).eResource() != null && ((EObject)match.getLeftRoots().get(0)).eResource().getURI() != null) {
            extension = ((EObject)match.getLeftRoots().get(0)).eResource().getURI().fileExtension();
        }
        IDiffEngine engine = DiffService.getBestDiffEngine(extension);
        DiffModel diff = engine.doDiff(match, threeWay);
        Collection<AbstractDiffExtension> extensions = DiffService.getCorrespondingDiffExtensions(extension);
        for (AbstractDiffExtension ext : extensions) {
            if (ext == null) continue;
            ext.visit(diff);
        }
        engine.reset();
        return diff;
    }

    public static DiffResourceSet doDiff(MatchResourceSet matchResourceSet) {
        return DiffService.doDiff(matchResourceSet, false);
    }

    public static DiffResourceSet doDiff(MatchResourceSet matchResourceSet, boolean threeWay) {
        DiffResourceSet diff = DiffFactory.eINSTANCE.createDiffResourceSet();
        EcoreUtil.CrossReferencer crossReferencer = new EcoreUtil.CrossReferencer((EObject)matchResourceSet){
            private static final long serialVersionUID = 1L;
            {
                this.crossReference();
            }
        };
        for (MatchModel match : matchResourceSet.getMatchModels()) {
            String extension = DEFAULT_EXTENSION;
            if (!match.getLeftRoots().isEmpty() && ((EObject)match.getLeftRoots().get(0)).eResource() != null) {
                extension = ((EObject)match.getLeftRoots().get(0)).eResource().getURI().fileExtension();
            }
            IDiffEngine engine = DiffService.getBestDiffEngine(extension);
            DiffModel diffmodel = engine.doDiffResourceSet(match, threeWay, crossReferencer);
            Collection<AbstractDiffExtension> extensions = DiffService.getCorrespondingDiffExtensions(extension);
            for (AbstractDiffExtension ext : extensions) {
                if (ext == null) continue;
                ext.visit(diffmodel);
            }
            engine.reset();
            diff.getDiffModels().add((Object)diffmodel);
        }
        for (UnmatchModel unmatch : matchResourceSet.getUnmatchedModels()) {
            ResourceDependencyChange dependencyChange = unmatch.getSide() == Side.LEFT ? DiffFactory.eINSTANCE.createResourceDependencyChangeRightTarget() : DiffFactory.eINSTANCE.createResourceDependencyChangeLeftTarget();
            if (unmatch.isRemote()) {
                dependencyChange.setRemote(true);
            }
            dependencyChange.getRoots().addAll((Collection)unmatch.getRoots());
            diff.getResourceDiffs().add((Object)dependencyChange);
        }
        return diff;
    }

    public static IDiffEngine getBestDiffEngine(String extension) {
        if (EMFPlugin.IS_ECLIPSE_RUNNING && EMFComparePlugin.getDefault().getBoolean("emfcompare.engine.selection")) {
            DiffEngineDescriptor desc = DiffService.getBestDescriptor(extension);
            return desc.getEngineInstance();
        }
        return DiffEngineRegistry.INSTANCE.getHighestEngine(extension);
    }

    public static void setDiffEngineSelector(IDiffEngineSelector selector) {
        diffEngineSelector = selector;
    }

    public static Collection<AbstractDiffExtension> getCorrespondingDiffExtensions(String extension) {
        ArrayList<AbstractDiffExtension> result = new ArrayList<AbstractDiffExtension>();
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            Collection descs;
            if (PARSED_DIFF_EXTENSIONS.containsKey(ALL_EXTENSIONS)) {
                for (DiffExtensionDescriptor extensionDesc : PARSED_DIFF_EXTENSIONS.get(ALL_EXTENSIONS)) {
                    result.add(extensionDesc.getDiffExtensionInstance());
                }
            }
            if ((descs = (Collection)PARSED_DIFF_EXTENSIONS.get(extension)) != null) {
                for (DiffExtensionDescriptor desc : descs) {
                    result.add(desc.getDiffExtensionInstance());
                }
            }
        }
        return result;
    }

    private static DiffEngineDescriptor getBestDescriptor(String extension) {
        List<DiffEngineDescriptor> engines = DiffEngineRegistry.INSTANCE.getDescriptors(extension);
        DiffEngineDescriptor engine = null;
        if (engines.size() == 1) {
            engine = engines.iterator().next();
        } else if (engines.size() > 1) {
            engine = diffEngineSelector.selectDiffEngine(engines);
        }
        return engine;
    }

    private static DiffExtensionDescriptor parseDiffExtension(IConfigurationElement configElement) {
        if (!configElement.getName().equals(TAG_DIFF_EXTENSION)) {
            return null;
        }
        DiffExtensionDescriptor desc = new DiffExtensionDescriptor(configElement);
        return desc;
    }

    private static void parseExtensionMetadata() {
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(DIFF_EXTENSION_EXTENSION_POINT).getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    DiffExtensionDescriptor desc = DiffService.parseDiffExtension(configElements[j]);
                    DiffService.storeDiffExtensionDescriptor(desc);
                    ++j;
                }
                ++i;
            }
        }
    }

    private static void storeDiffExtensionDescriptor(DiffExtensionDescriptor desc) {
        String[] extensions;
        if (desc.getFileExtension() == null) {
            return;
        }
        String[] stringArray = extensions = desc.getFileExtension().split(",");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            String engineExtension = stringArray[n2];
            if (!PARSED_DIFF_EXTENSIONS.containsKey(engineExtension)) {
                PARSED_DIFF_EXTENSIONS.put(engineExtension, new ArrayList());
            }
            List set = PARSED_DIFF_EXTENSIONS.get(engineExtension);
            set.add(desc);
            ++n2;
        }
    }
}

