/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.examples.extlibrary.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.BasicFeatureMap;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.Borrower;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Employee;
import org.eclipse.emf.examples.extlibrary.Item;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.examples.extlibrary.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryImpl
extends EObjectImpl
implements Library {
    protected static final String ADDRESS_EDEFAULT = null;
    protected String address = ADDRESS_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected EList<Item> stock;
    protected EList<Book> books;
    protected EList<Library> branches;
    protected FeatureMap people;

    protected LibraryImpl() {
    }

    protected EClass eStaticClass() {
        return EXTLibraryPackage.Literals.LIBRARY;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(String newAddress) {
        String oldAddress = this.address;
        this.address = newAddress;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldAddress, (Object)this.address));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public EList<Writer> getWriters() {
        return this.getPeople().list((EStructuralFeature)EXTLibraryPackage.Literals.LIBRARY__WRITERS);
    }

    @Override
    public EList<Employee> getEmployees() {
        return this.getPeople().list((EStructuralFeature)EXTLibraryPackage.Literals.LIBRARY__EMPLOYEES);
    }

    @Override
    public EList<Borrower> getBorrowers() {
        return this.getPeople().list((EStructuralFeature)EXTLibraryPackage.Literals.LIBRARY__BORROWERS);
    }

    @Override
    public EList<Item> getStock() {
        if (this.stock == null) {
            this.stock = new EObjectContainmentEList<Item>(Item.class, (InternalEObject)this, 5){
                private static final long serialVersionUID = 1L;

                protected void didAdd(int index, Item newObject) {
                    if (newObject instanceof Book && !LibraryImpl.this.getBooks().contains((Object)newObject)) {
                        LibraryImpl.this.getBooks().add((Object)((Book)newObject));
                    }
                }

                protected void didRemove(int index, Item oldObject) {
                    if (oldObject instanceof Book && LibraryImpl.this.getBooks().contains((Object)oldObject)) {
                        LibraryImpl.this.getBooks().remove((Object)oldObject);
                    }
                }

                protected void didSet(int index, Item newObject, Item oldObject) {
                    this.didRemove(index, oldObject);
                    this.didAdd(index, newObject);
                }
            };
        }
        return this.stock;
    }

    @Override
    public EList<Book> getBooks() {
        if (this.books == null) {
            this.books = new EObjectEList<Book>(Book.class, (InternalEObject)this, 6){
                private static final long serialVersionUID = 1L;

                protected void didAdd(int index, Book newObject) {
                    if (LibraryImpl.this.getStock().indexOf((Object)newObject) == -1) {
                        LibraryImpl.this.getStock().add((Object)newObject);
                    }
                }

                protected void didRemove(int index, Book oldObject) {
                    if (LibraryImpl.this.getStock().indexOf((Object)oldObject) != -1) {
                        LibraryImpl.this.getStock().remove((Object)oldObject);
                    }
                }

                protected void didSet(int index, Book newObject, Book oldObject) {
                    this.didRemove(index, oldObject);
                    this.didAdd(index, newObject);
                }
            };
        }
        return this.books;
    }

    @Override
    public EList<Library> getBranches() {
        if (this.branches == null) {
            this.branches = new EObjectContainmentWithInverseEList.Resolving(Library.class, (InternalEObject)this, 7, 8);
        }
        return this.branches;
    }

    @Override
    public Library getParentBranch() {
        if (this.eContainerFeatureID != 8) {
            return null;
        }
        return (Library)this.eContainer();
    }

    public Library basicGetParentBranch() {
        if (this.eContainerFeatureID != 8) {
            return null;
        }
        return (Library)this.eInternalContainer();
    }

    public NotificationChain basicSetParentBranch(Library newParentBranch, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newParentBranch, 8, msgs);
        return msgs;
    }

    @Override
    public void setParentBranch(Library newParentBranch) {
        if (newParentBranch != this.eInternalContainer() || this.eContainerFeatureID != 8 && newParentBranch != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newParentBranch)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newParentBranch != null) {
                msgs = ((InternalEObject)newParentBranch).eInverseAdd((InternalEObject)this, 7, Library.class, msgs);
            }
            if ((msgs = this.basicSetParentBranch(newParentBranch, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)newParentBranch, (Object)newParentBranch));
        }
    }

    @Override
    public FeatureMap getPeople() {
        if (this.people == null) {
            this.people = new BasicFeatureMap((InternalEObject)this, 9);
        }
        return this.people;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return ((InternalEList)this.getBranches()).basicAdd((Object)otherEnd, msgs);
            }
            case 8: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetParentBranch((Library)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getWriters()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getEmployees()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getBorrowers()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getStock()).basicRemove((Object)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getBranches()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return this.basicSetParentBranch(null, msgs);
            }
            case 9: {
                return ((InternalEList)this.getPeople()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID) {
            case 8: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 7, Library.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAddress();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getWriters();
            }
            case 3: {
                return this.getEmployees();
            }
            case 4: {
                return this.getBorrowers();
            }
            case 5: {
                return this.getStock();
            }
            case 6: {
                return this.getBooks();
            }
            case 7: {
                return this.getBranches();
            }
            case 8: {
                if (resolve) {
                    return this.getParentBranch();
                }
                return this.basicGetParentBranch();
            }
            case 9: {
                if (coreType) {
                    return this.getPeople();
                }
                return ((FeatureMap.Internal)this.getPeople()).getWrapper();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setAddress((String)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.getWriters().clear();
                this.getWriters().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getEmployees().clear();
                this.getEmployees().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getBorrowers().clear();
                this.getBorrowers().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getStock().clear();
                this.getStock().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.getBooks().clear();
                this.getBooks().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getBranches().clear();
                this.getBranches().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.setParentBranch((Library)newValue);
                return;
            }
            case 9: {
                ((FeatureMap.Internal)this.getPeople()).set(newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setAddress(ADDRESS_EDEFAULT);
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.getWriters().clear();
                return;
            }
            case 3: {
                this.getEmployees().clear();
                return;
            }
            case 4: {
                this.getBorrowers().clear();
                return;
            }
            case 5: {
                this.getStock().clear();
                return;
            }
            case 6: {
                this.getBooks().clear();
                return;
            }
            case 7: {
                this.getBranches().clear();
                return;
            }
            case 8: {
                this.setParentBranch(null);
                return;
            }
            case 9: {
                this.getPeople().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return ADDRESS_EDEFAULT == null ? this.address != null : !ADDRESS_EDEFAULT.equals(this.address);
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return !this.getWriters().isEmpty();
            }
            case 3: {
                return !this.getEmployees().isEmpty();
            }
            case 4: {
                return !this.getBorrowers().isEmpty();
            }
            case 5: {
                return this.stock != null && !this.stock.isEmpty();
            }
            case 6: {
                return this.books != null && !this.books.isEmpty();
            }
            case 7: {
                return this.branches != null && !this.branches.isEmpty();
            }
            case 8: {
                return this.basicGetParentBranch() != null;
            }
            case 9: {
                return this.people != null && !this.people.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (address: ");
        result.append(this.address);
        result.append(", name: ");
        result.append(this.name);
        result.append(", people: ");
        result.append(this.people);
        result.append(')');
        return result.toString();
    }
}

