/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.prefs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.om.pref.OMPreference;
import org.eclipse.net4j.util.om.pref.OMPreferences;
import org.eclipse.net4j.util.om.pref.OMPreferencesChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMPreferenceStore
implements IPreferenceStore {
    private OMPreferences preferences;
    private List<IPropertyChangeListener> listeners = new ArrayList<IPropertyChangeListener>(0);
    private IListener preferencesListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof OMPreferencesChangeEvent) {
                OMPreferencesChangeEvent e = (OMPreferencesChangeEvent)event;
                OMPreferenceStore.this.firePropertyChangeEvent(e.getPreference().getName(), e.getOldValue(), e.getNewValue());
            }
        }
    };

    public OMPreferenceStore(OMPreferences preferences) {
        this.preferences = preferences;
        preferences.addListener(this.preferencesListener);
    }

    public void dispose() {
        this.preferences.removeListener(this.preferencesListener);
    }

    public OMPreferences getPreferences() {
        return this.preferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        List<IPropertyChangeListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        List<IPropertyChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
        IPropertyChangeListener[] iPropertyChangeListenerArray = this.getPropertyChangeListenerListeners();
        int n = iPropertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyChangeListener listener = iPropertyChangeListenerArray[n2];
            try {
                listener.propertyChange(event);
            }
            catch (RuntimeException ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
    }

    public boolean contains(String name) {
        return this.preferences.contains(name);
    }

    public boolean isDefault(String name) {
        return !this.getPreference(name).isSet();
    }

    public boolean needsSaving() {
        return this.preferences.isDirty();
    }

    public boolean getDefaultBoolean(String name) {
        return (Boolean)this.getPreference(name).getDefaultValue();
    }

    public double getDefaultDouble(String name) {
        return (Double)this.getPreference(name).getDefaultValue();
    }

    public float getDefaultFloat(String name) {
        return ((Float)this.getPreference(name).getDefaultValue()).floatValue();
    }

    public int getDefaultInt(String name) {
        return (Integer)this.getPreference(name).getDefaultValue();
    }

    public long getDefaultLong(String name) {
        return (Long)this.getPreference(name).getDefaultValue();
    }

    public String getDefaultString(String name) {
        return (String)this.getPreference(name).getDefaultValue();
    }

    public void setDefault(String name, boolean value) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String name, double value) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String name, float value) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String name, int value) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String name, long value) {
        throw new UnsupportedOperationException();
    }

    public void setDefault(String name, String defaultObject) {
        throw new UnsupportedOperationException();
    }

    public void setToDefault(String name) {
        this.getPreference(name).unSet();
    }

    public boolean getBoolean(String name) {
        return (Boolean)this.getPreference(name).getValue();
    }

    public double getDouble(String name) {
        return (Double)this.getPreference(name).getValue();
    }

    public float getFloat(String name) {
        return ((Float)this.getPreference(name).getValue()).floatValue();
    }

    public int getInt(String name) {
        return (Integer)this.getPreference(name).getValue();
    }

    public long getLong(String name) {
        return (Long)this.getPreference(name).getValue();
    }

    public String getString(String name) {
        return (String)this.getPreference(name).getValue();
    }

    public void putValue(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public void setValue(String name, boolean value) {
        OMPreference<?> pref = this.getPreference(name);
        pref.setValue((Object)value);
    }

    public void setValue(String name, double value) {
        OMPreference<?> pref = this.getPreference(name);
        pref.setValue((Object)value);
    }

    public void setValue(String name, float value) {
        OMPreference<?> pref = this.getPreference(name);
        pref.setValue((Object)Float.valueOf(value));
    }

    public void setValue(String name, int value) {
        OMPreference<?> pref = this.getPreference(name);
        pref.setValue((Object)value);
    }

    public void setValue(String name, long value) {
        OMPreference<?> pref = this.getPreference(name);
        pref.setValue((Object)value);
    }

    public void setValue(String name, String value) {
        OMPreference<?> pref = this.getPreference(name);
        pref.setValue((Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPropertyChangeListener[] getPropertyChangeListenerListeners() {
        List<IPropertyChangeListener> list = this.listeners;
        synchronized (list) {
            return this.listeners.toArray(new IPropertyChangeListener[this.listeners.size()]);
        }
    }

    private OMPreference<?> getPreference(String name) {
        OMPreference pref = this.preferences.get(name);
        if (pref == null) {
            throw new IllegalStateException("No preference for " + name);
        }
        return pref;
    }
}

