/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.ui.debug.breakpoint.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.mwe.internal.ui.debug.breakpoint.actions.BreakpointActionGroup;
import org.eclipse.emf.mwe.ui.Messages;
import org.eclipse.emf.mwe.ui.debug.processing.PluginAdapter;
import org.eclipse.emf.mwe.ui.debug.processing.PluginExtensionManager;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.editors.text.TextEditor;

public class ToggleBreakpointAction
extends Action {
    private final TextEditor editor;
    private final BreakpointActionGroup group;

    public ToggleBreakpointAction(TextEditor editor, BreakpointActionGroup group) {
        this.editor = editor;
        this.group = group;
        this.setText(Messages.ToggleBreakpointAction_Title);
        this.setToolTipText(Messages.ToggleBreakpointAction_Description);
    }

    public void updateText() {
        IResource resource = (IResource)this.editor.getEditorInput().getAdapter(IResource.class);
        PluginAdapter adapter = PluginExtensionManager.getDefault().getAdapterByResourceExtension(resource.getFileExtension());
        if (adapter == null) {
            return;
        }
        int line = this.group.getLastSelectedLine() + 1;
        int start = this.group.getLastSelectedOffset();
        int end = this.calculateEnd(line, start);
        if (this.group.isRulerSelected()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(adapter.isToggleBpEnabled(resource, start, end, line));
        }
    }

    public void run() {
        try {
            this.toggleBreakpoint();
        }
        catch (CoreException coreException) {}
    }

    protected void toggleBreakpoint() throws CoreException {
        IResource resource = (IResource)this.editor.getEditorInput().getAdapter(IResource.class);
        int line = this.group.getLastSelectedLine() + 1;
        int start = this.group.getLastSelectedOffset();
        PluginAdapter adapter = PluginExtensionManager.getDefault().getAdapterByResourceExtension(resource.getFileExtension());
        if (adapter == null) {
            return;
        }
        int end = this.calculateEnd(line, start);
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints("org.eclipse.emf.mwe.debug.model");
        Object bp = adapter.checkBreakpoints(breakpoints, resource, start, end, line);
        if (bp != null) {
            bp.delete();
            return;
        }
        bp = adapter.createBreakpoint(resource, start, end, line);
        if (bp == null) {
            return;
        }
        breakpointManager.addBreakpoint(bp);
    }

    private int calculateEnd(int line, int start) {
        int end;
        try {
            end = this.group.isRulerSelected() ? this.group.getOffsetAtLine(line) : start;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            end = start;
        }
        return end;
    }
}

