/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.mvc.controller;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.net4j.examples.mvc.IAdapter;
import org.eclipse.net4j.examples.mvc.IBinding;
import org.eclipse.net4j.examples.mvc.IController;
import org.eclipse.net4j.examples.mvc.controller.ControllerAspectData;
import org.eclipse.net4j.examples.mvc.util.AbstractAspectDataMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller<TARGET>
extends AbstractAspectDataMap<ControllerAspectData<TARGET>, TARGET>
implements IController<TARGET> {
    private IAdapter.Manager<TARGET> adapterManager;
    private String name;
    private Map<String, TARGET> targets = new HashMap<String, TARGET>();

    public Controller(IAdapter.Manager<TARGET> adapterManager, String name) {
        this.adapterManager = adapterManager;
        this.name = name;
        Class[] aspects = adapterManager.getAspects();
        int i = 0;
        while (i < aspects.length) {
            this.ensureAspectData(aspects[i]);
            ++i;
        }
    }

    @Override
    public IAdapter.Manager<TARGET> getAdapterManager() {
        return this.adapterManager;
    }

    public Set<IBinding<TARGET>> getBindings(Class aspect) {
        ControllerAspectData data = (ControllerAspectData)this.getAspectData(aspect);
        return data.getBindings();
    }

    @Override
    public void addBinding(IBinding<TARGET> binding) {
        this.getBindings(binding).add(binding);
        String targetName = binding.getTargetName();
        TARGET target = this.getTarget(targetName);
        if (target != null) {
            this.retargetBingings(targetName, target);
        }
    }

    @Override
    public boolean mayClose() {
        return true;
    }

    @Override
    public void dispose() {
        Class[] aspects = this.adapterManager.getAspects();
        int i = 0;
        while (i < aspects.length) {
            Set<IBinding<TARGET>> bindings = this.getBindings(aspects[i]);
            IBinding[] array = bindings.toArray(new IBinding[bindings.size()]);
            int j = 0;
            while (j < array.length) {
                IBinding binding = array[j];
                IAdapter adapter = binding.getAdapter();
                if (adapter != null && adapter.removeBinding(binding)) {
                    this.adapterManager.removeAdapter(adapter.getTarget());
                }
                this.removeBinding(binding);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void removeBinding(IBinding<TARGET> binding) {
        this.getBindings(binding).remove(binding);
    }

    @Override
    public IAdapter<TARGET> adapt(Class aspect, TARGET target) {
        return this.getAdapterManager().adapt(aspect, target);
    }

    @Override
    public TARGET putTarget(String name, TARGET target) {
        TARGET oldTarget = this.targets.put(name, target);
        if (target == oldTarget) {
            return target;
        }
        this.retargetBingings(name, target);
        this.onRetarget(name, target, oldTarget);
        return oldTarget;
    }

    protected void onRetarget(String name, TARGET newTarget, TARGET oldTarget) {
    }

    private void retargetBingings(String targetName, TARGET target) {
        Class[] aspects = this.adapterManager.getAspects();
        int i = 0;
        while (i < aspects.length) {
            Set<IBinding<TARGET>> bindings = this.getBindings(aspects[i]);
            for (IBinding<TARGET> binding : bindings) {
                if (!binding.getTargetName().equals(targetName)) continue;
                binding.setTarget(target);
            }
            ++i;
        }
    }

    @Override
    public TARGET removeTarget(String name) {
        return this.targets.remove(name);
    }

    @Override
    public TARGET getTarget(String name) {
        return this.targets.get(name);
    }

    @Override
    public Map<String, TARGET> getTargets() {
        return this.targets;
    }

    @Override
    protected ControllerAspectData<TARGET> createData() {
        return new ControllerAspectData();
    }

    private Set<IBinding<TARGET>> getBindings(IBinding<TARGET> binding) {
        Class aspect = binding.getAspect();
        return this.getBindings(aspect);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void afterTargetsSet() {
    }
}

