/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.mvc.controller;

import org.eclipse.net4j.examples.mvc.IAdapter;
import org.eclipse.net4j.examples.mvc.IRecordController;
import org.eclipse.net4j.examples.mvc.ISequenceController;
import org.eclipse.net4j.examples.mvc.binding.SelectionViewBinding;
import org.eclipse.net4j.examples.mvc.controller.AbstractSequenceController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionSequenceController<SEQUENCE_TARGET, RECORD_TARGET, VIEW_TARGET>
extends AbstractSequenceController<SEQUENCE_TARGET, RECORD_TARGET, VIEW_TARGET>
implements ISequenceController<SEQUENCE_TARGET, RECORD_TARGET, VIEW_TARGET> {
    private SelectionViewBinding<VIEW_TARGET> selectionViewBinding;

    public SelectionSequenceController(IAdapter.Manager<Object> adapterManager, String name, String sequenceModelTargetName, String selectionViewTargetName, IRecordController<RECORD_TARGET, VIEW_TARGET> recordController) {
        super(adapterManager, name, sequenceModelTargetName, recordController);
        this.selectionViewBinding = new SelectionViewBinding(this, selectionViewTargetName){

            public boolean onSelection(Object item, int detail, int x, int y, int width, int height, int stateMask, boolean doit) {
                int index = this.getSelectionIndex();
                return SelectionSequenceController.this.onViewSelection(index);
            }
        };
    }

    public SelectionViewBinding<VIEW_TARGET> getSelectionViewBinding() {
        return this.selectionViewBinding;
    }

    @Override
    protected void init() {
        if (this.getSequenceModelBinding().isEmpty()) {
            if (this.getRecordController() != null) {
                this.getRecordController().enableView(false);
            }
            return;
        }
        if (this.getRecordController() != null) {
            Object recordTarget = this.getSequenceModelBinding().get(0);
            this.getRecordController().setRecordTarget(recordTarget);
            this.getRecordController().loadView();
        }
        if (this.getSelectionViewBinding().getTarget() == null || this.getSequenceModelBinding().getTarget() == null) {
            return;
        }
        for (Object item : this.getSequenceModelBinding()) {
            this.getSelectionViewBinding().add(this.itemToString(item));
        }
        this.gotoFirst();
    }

    @Override
    public void gotoIndex(int index) {
        int oldIndex = this.getCurrentIndex();
        if (index != oldIndex && this.getRecordController().isDirty() && !this.leaveDirtyRecord()) {
            return;
        }
        this.setCurrentIndex(index);
        this.getSelectionViewBinding().setSelection(index);
        if (this.getRecordController() != null) {
            if (index == -1) {
                this.getRecordController().enableView(false);
                this.getRecordController().clearView();
            } else {
                this.getRecordController().enableView(true);
                Object recordTarget = this.getSequenceModelBinding().get(index);
                this.getRecordController().setRecordTarget(recordTarget);
                this.getRecordController().loadView();
            }
        }
    }

    @Override
    protected void onModelSet(int index, Object newItem, Object oldItem) {
    }

    @Override
    protected void onModelRemove(int index, Object item) {
        this.getSelectionViewBinding().remove(index);
    }

    @Override
    protected void onModelMove(int fromIndex, int toIndex) {
    }

    @Override
    protected void onModelAdd(int index, Object item) {
        this.getSelectionViewBinding().add(this.itemToString(item), index);
    }

    protected boolean onViewSelection(int index) {
        this.gotoIndex(index);
        return true;
    }
}

