/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.ResourceMarker;
import org.eclipse.gmf.internal.xpand.eval.EvaluationListener;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.PolymorphicResolver;
import org.eclipse.gmf.internal.xpand.expression.TypeNameUtil;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.migration.Activator;
import org.eclipse.gmf.internal.xpand.util.ClassLoadContext;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;
import org.eclipse.gmf.internal.xpand.xtend.ast.XtendResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionContextImpl
implements ExecutionContext {
    private final Map<String, Variable> variables = new HashMap<String, Variable>();
    private final Map<String, Variable> globalVars = new HashMap<String, Variable>();
    private ClassLoadContext contextClassLoader;
    private EvaluationListener evaluationListener;
    private ResourceMarker currentResource;
    private final ResourceManager resourceManager;
    private Collection<EPackage> fallbackVisibleModels = new LinkedHashSet<EPackage>();
    private Set<Extension> allExtensions = null;

    public ExecutionContextImpl(ResourceManager resourceManager, EPackage ... fallbackVisibleModels) {
        this(resourceManager, (Collection<Variable>)null);
        EPackage[] ePackageArray = fallbackVisibleModels;
        int n = fallbackVisibleModels.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage ePackage = ePackageArray[n2];
            this.fallbackVisibleModels.add(ePackage);
            ++n2;
        }
    }

    public ExecutionContextImpl(ResourceManager resourceManager, Collection<Variable> globalVars) {
        this(resourceManager, null, null, globalVars);
    }

    public ExecutionContextImpl(ResourceManager resourceManager, ResourceMarker resource, Collection<Variable> variables, Collection<Variable> globalVars) {
        this.resourceManager = resourceManager;
        this.currentResource = resource;
        if (variables != null) {
            for (Variable v : variables) {
                this.variables.put(v.getName(), v);
            }
        }
        if (globalVars != null) {
            for (Variable v : globalVars) {
                this.globalVars.put(v.getName(), v);
            }
        }
        this.fallbackVisibleModels.add((EPackage)EcorePackage.eINSTANCE);
    }

    protected ExecutionContextImpl(ExecutionContextImpl original) {
        this.resourceManager = original.resourceManager;
        this.currentResource = original.currentResource;
        this.variables.putAll(original.variables);
        this.globalVars.putAll(original.globalVars);
        this.contextClassLoader = original.contextClassLoader;
        this.evaluationListener = original.evaluationListener;
        this.fallbackVisibleModels = original.fallbackVisibleModels;
    }

    @Override
    public EClassifier[] findTypesForPrefix(String prefix) {
        String simpleTypeName;
        EPackage[] importedNamespaces;
        String typeName = TypeNameUtil.getTypeName(prefix);
        TypeNameUtil.getMetaModelName(typeName);
        String collectionTypeName = TypeNameUtil.getCollectionTypeName(prefix);
        if (TypeNameUtil.isQualifiedName(typeName)) {
            EPackage exactNamespace = this.findImportedNamespace(TypeNameUtil.withoutLastSegment(typeName));
            if (exactNamespace == null) {
                return new EClassifier[0];
            }
            importedNamespaces = new EPackage[]{exactNamespace};
            simpleTypeName = TypeNameUtil.getLastSegment(typeName);
        } else {
            importedNamespaces = this.getAllVisibleModels();
            simpleTypeName = TypeNameUtil.toCanonicalNameFromAlias(typeName);
        }
        if (collectionTypeName != null && !BuiltinMetaModel.isCollectionMetaType(collectionTypeName)) {
            return new EClassifier[0];
        }
        ArrayList result = new ArrayList();
        EPackage[] ePackageArray = importedNamespaces;
        int n = importedNamespaces.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage namespace = ePackageArray[n2];
            if (simpleTypeName == null || simpleTypeName.trim().length() == 0) {
                result.addAll((Collection)namespace.getEClassifiers());
            } else {
                result.addAll(ExecutionContextImpl.filterByNamePrefix(simpleTypeName, namespace.getEClassifiers()));
            }
            ++n2;
        }
        if (collectionTypeName == null) {
            return result.toArray(new EClassifier[result.size()]);
        }
        EClassifier[] rv = new EClassifier[result.size()];
        Iterator iterator = result.iterator();
        int i = 0;
        while (i < rv.length) {
            rv[i] = BuiltinMetaModel.getCollectionType(collectionTypeName, (EClassifier)iterator.next());
            ++i;
        }
        return rv;
    }

    private EPackage findImportedNamespace(String namespace) {
        assert (namespace != null);
        LinkedList<EPackage> potentialMatches = new LinkedList<EPackage>();
        potentialMatches.addAll(Arrays.asList(this.getAllVisibleModels()));
        String[] namespaceChain = namespace.split("::");
        EPackage returnValue = null;
        String[] stringArray = namespaceChain;
        int n = namespaceChain.length;
        int n2 = 0;
        while (n2 < n) {
            String namespacePart = stringArray[n2];
            LinkedList subPackages = new LinkedList();
            returnValue = null;
            for (EPackage candidate : potentialMatches) {
                if (!candidate.getName().equals(namespacePart)) continue;
                subPackages.addAll(candidate.getESubpackages());
                returnValue = candidate;
                break;
            }
            potentialMatches = subPackages;
            ++n2;
        }
        return returnValue;
    }

    private static <T extends ENamedElement> Collection<T> filterByNamePrefix(String namePrefix, Collection<? extends T> knownNamedElements) {
        HashSet<ENamedElement> result = new HashSet<ENamedElement>();
        for (ENamedElement t : knownNamedElements) {
            if (!t.getName().startsWith(namePrefix)) continue;
            result.add(t);
        }
        return result;
    }

    public void setContextClassLoader(ClassLoadContext classLoadContext) {
        this.contextClassLoader = classLoadContext;
    }

    @Override
    public Class<?> loadClass(String value) {
        try {
            Class<?> c;
            if (this.contextClassLoader != null && (c = this.contextClassLoader.load(value)) != null) {
                return c;
            }
            return Class.forName(value);
        }
        catch (ClassNotFoundException ex) {
            ex.getMessage();
            return null;
        }
    }

    protected EPackage[] getAllVisibleModels() {
        String[] importedNamespaces = this.getImportedNamespaces();
        assert (importedNamespaces != null);
        LinkedList<EPackage> result = new LinkedList<EPackage>();
        String[] stringArray = importedNamespaces;
        int n = importedNamespaces.length;
        int n2 = 0;
        while (n2 < n) {
            String namespace = stringArray[n2];
            EPackage pkg = Activator.findMetaModel(namespace);
            if (pkg != null) {
                result.add(pkg);
            }
            ++n2;
        }
        if (result.isEmpty()) {
            result.addAll(this.fallbackVisibleModels);
        }
        return result.toArray(new EPackage[result.size()]);
    }

    @Override
    public EClassifier getTypeForName(String name) {
        String simpleTypeName = TypeNameUtil.toCanonicalNameFromAlias(TypeNameUtil.getSimpleName(TypeNameUtil.getTypeName(name)));
        String collectionTypeName = TypeNameUtil.getCollectionTypeName(name);
        EClassifier[] eClassifierArray = this.findTypesForPrefix(name);
        int n = eClassifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            EClassifier potentialMatch = eClassifierArray[n2];
            if (collectionTypeName != null) {
                assert (BuiltinMetaModel.isParameterizedType(potentialMatch));
                if (BuiltinMetaModel.getInnerType(potentialMatch).getName().equals(simpleTypeName)) {
                    return potentialMatch;
                }
            } else if (potentialMatch.getName().equals(simpleTypeName)) {
                return potentialMatch;
            }
            ++n2;
        }
        return null;
    }

    protected String[] getImportedNamespaces() {
        if (this.currentResource() instanceof XtendResource) {
            return ((XtendResource)this.currentResource()).getImportedNamespaces();
        }
        return new String[0];
    }

    protected String[] getImportedExtensions() {
        if (this.currentResource() instanceof XtendResource) {
            return ((XtendResource)this.currentResource()).getImportedExtensions();
        }
        return new String[0];
    }

    public ExecutionContext cloneContext() {
        return new ExecutionContextImpl(this);
    }

    protected final ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public Variable getVariable(String name) {
        return this.variables.get(name);
    }

    @Override
    public Collection<Variable> getVisibleVariables() {
        return Collections.unmodifiableCollection(this.variables.values());
    }

    @Override
    public Collection<Variable> getGlobalVariables() {
        return Collections.unmodifiableCollection(this.globalVars.values());
    }

    @Override
    public Variable getGlobalVariable(String name) {
        return this.globalVars.get(name);
    }

    public ExecutionContext cloneWithVariable(Variable ... vars) {
        ExecutionContextImpl result = (ExecutionContextImpl)this.cloneContext();
        Variable[] variableArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            Variable v = variableArray[n2];
            result.variables.put(v.getName(), v);
            ++n2;
        }
        return result;
    }

    @Override
    public <T extends ExecutionContext> T cloneWithVariable(Collection<Variable> v) {
        return (T)this.cloneWithVariable(v.toArray(new Variable[v.size()]));
    }

    public ExecutionContext cloneWithoutVariables() {
        ExecutionContextImpl result = (ExecutionContextImpl)this.cloneContext();
        result.variables.clear();
        return result;
    }

    public ExecutionContext cloneWithResource(ResourceMarker ns) {
        ExecutionContextImpl ctx = (ExecutionContextImpl)this.cloneContext();
        ctx.currentResource = ns;
        return ctx;
    }

    @Override
    public ResourceMarker currentResource() {
        return this.currentResource;
    }

    @Override
    public Set<Extension> getAllExtensions() {
        if (this.allExtensions == null) {
            this.allExtensions = new HashSet<Extension>();
            ResourceMarker res = this.currentResource();
            if (res != null) {
                String[] extensions;
                String[] stringArray = extensions = this.getImportedExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    XtendResource extFile = this.resourceManager.loadXtendResource(extension);
                    if (extFile == null) {
                        throw new RuntimeException("Unable to load extension file : " + extension);
                    }
                    ExecutionContext ctx = this.cloneWithResource(extFile);
                    List<Extension> extensionList = extFile.getPublicExtensions(this.resourceManager);
                    for (Extension element : extensionList) {
                        element.init(ctx);
                        this.allExtensions.add(element);
                    }
                    ++n2;
                }
                if (res instanceof XtendResource) {
                    List<Extension> extensionList = ((XtendResource)res).getExtensions();
                    for (Extension element : extensionList) {
                        element.init(this);
                        this.allExtensions.add(element);
                    }
                }
            }
        }
        return this.allExtensions;
    }

    @Override
    public Extension getExtension(String functionName, EClassifier[] parameterTypes) {
        return PolymorphicResolver.getExtension(this.getAllExtensions(), functionName, Arrays.asList(parameterTypes));
    }

    @Override
    public EvaluationListener getEvaluationListener() {
        return this.evaluationListener;
    }

    public void setEvaluationListener(EvaluationListener listener) {
        this.evaluationListener = listener;
    }
}

