/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.xtend.ast;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.ast.SyntaxElement;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;
import org.eclipse.gmf.internal.xpand.xtend.ast.ImportStatement;
import org.eclipse.gmf.internal.xpand.xtend.ast.XtendResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionFile
extends SyntaxElement
implements XtendResource {
    private final List<ImportStatement> nsImports;
    private final List<ImportStatement> extImports;
    private final List<Extension> extensions;
    private String fullyQualifiedName;

    public ExtensionFile(int start, int end, int line, int startOffset, int endOffset, List<? extends SyntaxElement> nsImports, List<? extends SyntaxElement> extImports, List<? extends SyntaxElement> extensions) {
        super(start, end, line, startOffset, endOffset);
        this.nsImports = nsImports;
        this.extImports = extImports;
        this.extensions = extensions;
        for (Extension ext : this.extensions) {
            ext.setExtensionFile(this);
        }
    }

    @Override
    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public List<ImportStatement> getExtImports() {
        return this.extImports;
    }

    public List<ImportStatement> getNsImports() {
        return this.nsImports;
    }

    @Override
    public String[] getImportedNamespaces() {
        ArrayList<String> namespaces = new ArrayList<String>(this.getNsImports().size());
        for (ImportStatement nsImport : this.getNsImports()) {
            namespaces.add(nsImport.getValue());
        }
        return namespaces.toArray(new String[namespaces.size()]);
    }

    @Override
    public String[] getImportedExtensions() {
        ArrayList<String> result = new ArrayList<String>(this.getExtImports().size());
        for (ImportStatement nsImport : this.getExtImports()) {
            result.add(nsImport.getValue());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        ctx = ctx.cloneWithResource(this);
        for (Extension ext : this.getExtensions()) {
            ext.analyze(ctx, issues);
        }
    }

    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @Override
    public List<Extension> getPublicExtensions(ResourceManager rm) {
        ArrayList<Extension> result = new ArrayList<Extension>();
        for (Extension element : this.getExtensions()) {
            if (element.isPrivate()) continue;
            result.add(element);
        }
        for (ImportStatement imp : this.getExtImports()) {
            if (!imp.isExported()) continue;
            XtendResource xf = rm.loadXtendResource(imp.getImportedId().getValue());
            result.addAll(xf.getPublicExtensions(rm));
        }
        return result;
    }

    @Override
    public boolean isReexported(String importedExtensionName) {
        for (ImportStatement extensionImport : this.getExtImports()) {
            if (!extensionImport.getValue().equals(importedExtensionName)) continue;
            return extensionImport.isExported();
        }
        return false;
    }
}

