/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.resources.editor.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorPlugin;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.l10n.EditorMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public abstract class DiagramFileCreator {
    public abstract String getExtension();

    protected Plugin getPlugin() {
        return EditorPlugin.getInstance();
    }

    private IFile createFileHandle(IPath filePath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
    }

    public String appendExtensionToFileName(String szFileName) {
        if (!szFileName.endsWith(this.getExtension())) {
            return String.valueOf(szFileName) + this.getExtension();
        }
        return szFileName;
    }

    public String getUniqueFileName(IPath containerPath, String szFileName) {
        int nFileNumber = 1;
        String szNewFileName = szFileName;
        IPath filePath = containerPath.append(this.appendExtensionToFileName(szNewFileName));
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        while (workspaceRoot.exists(filePath)) {
            szNewFileName = String.valueOf(szFileName) + ++nFileNumber;
            filePath = containerPath.append(this.appendExtensionToFileName(szNewFileName));
        }
        return szNewFileName;
    }

    protected void createFile(IFile fileHandle, InputStream contents, IProgressMonitor monitor) throws CoreException {
        if (contents == null) {
            contents = new ByteArrayInputStream(new byte[0]);
        }
        try {
            fileHandle.create(contents, false, monitor);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            Log.error((Plugin)this.getPlugin(), (int)4, (String)e.getMessage(), (Throwable)e);
            throw e;
        }
        if (monitor.isCanceled()) {
            OperationCanceledException oce = new OperationCanceledException();
            Log.error((Plugin)this.getPlugin(), (int)4, (String)oce.getMessage(), (Throwable)oce);
            throw oce;
        }
    }

    private void createFile(IFile fileHandle, InputStream contents, IRunnableContext runContext) throws InterruptedException, InvocationTargetException {
        try {
            this.createFile(fileHandle, contents, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Log.error((Plugin)this.getPlugin(), (int)4, (String)e.getMessage(), (Throwable)e);
            throw new InvocationTargetException(e);
        }
    }

    public IFile createNewFile(IPath containerPath, String fileName, InputStream initialContents, Shell shell, IRunnableContext runContext) {
        IPath newFilePath = containerPath.append(this.appendExtensionToFileName(fileName));
        IFile newFileHandle = this.createFileHandle(newFilePath);
        try {
            this.createFile(newFileHandle, initialContents, runContext);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)shell, (String)EditorMessages.Editor_error_create_file_title, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                Log.error((Plugin)EditorPlugin.getInstance(), (int)1, (String)NLS.bind((String)"Exception in {0}.getNewFile(): {1}", (Object[])new Object[]{this.getClass().getName(), e.getTargetException()}), (Throwable)e);
                MessageDialog.openError((Shell)shell, (String)EditorMessages.Editor_error_create_file_title, (String)NLS.bind((String)EditorMessages.Editor_error_create_file_message, (Object)e.getTargetException().getMessage()));
            }
            return null;
        }
        IFile newFile = newFileHandle;
        return newFile;
    }
}

