/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font;

import org.apache.batik.svggen.font.Point;
import org.apache.batik.svggen.font.table.GlyphDescription;

public class Glyph {
    protected short leftSideBearing;
    protected int advanceWidth;
    private Point[] points;

    public Glyph(GlyphDescription glyphDescription, short s, int n) {
        this.leftSideBearing = s;
        this.advanceWidth = n;
        this.describe(glyphDescription);
    }

    public int getAdvanceWidth() {
        return this.advanceWidth;
    }

    public short getLeftSideBearing() {
        return this.leftSideBearing;
    }

    public Point getPoint(int n) {
        return this.points[n];
    }

    public int getPointCount() {
        return this.points.length;
    }

    public void reset() {
    }

    public void scale(int n) {
        int n2 = 0;
        while (n2 < this.points.length) {
            this.points[n2].x = (this.points[n2].x << 10) * n >> 26;
            this.points[n2].y = (this.points[n2].y << 10) * n >> 26;
            ++n2;
        }
        this.leftSideBearing = (short)(this.leftSideBearing * n >> 6);
        this.advanceWidth = this.advanceWidth * n >> 6;
    }

    private void describe(GlyphDescription glyphDescription) {
        int n = 0;
        this.points = new Point[glyphDescription.getPointCount() + 2];
        int n2 = 0;
        while (n2 < glyphDescription.getPointCount()) {
            boolean bl;
            boolean bl2 = bl = glyphDescription.getEndPtOfContours(n) == n2;
            if (bl) {
                ++n;
            }
            this.points[n2] = new Point(glyphDescription.getXCoordinate(n2), glyphDescription.getYCoordinate(n2), (glyphDescription.getFlags(n2) & 1) != 0, bl);
            ++n2;
        }
        this.points[glyphDescription.getPointCount()] = new Point(0, 0, true, true);
        this.points[glyphDescription.getPointCount() + 1] = new Point(this.advanceWidth, 0, true, true);
    }
}

