/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate.ocl;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ocl.expressions.CollectionItem;
import org.eclipse.emf.ocl.expressions.CollectionLiteralExp;
import org.eclipse.emf.ocl.expressions.CollectionLiteralPart;
import org.eclipse.emf.ocl.expressions.ExpressionsFactory;
import org.eclipse.emf.ocl.expressions.OCLExpression;
import org.eclipse.emf.ocl.expressions.TypeExp;
import org.eclipse.emf.ocl.expressions.Variable;
import org.eclipse.emf.ocl.expressions.util.ExpressionsUtil;
import org.eclipse.emf.ocl.parser.EcoreEnvironment;
import org.eclipse.emf.ocl.parser.EcoreEnvironmentFactory;
import org.eclipse.emf.ocl.parser.Environment;
import org.eclipse.emf.ocl.parser.EnvironmentFactory;
import org.eclipse.emf.ocl.parser.ParserException;
import org.eclipse.emf.ocl.parser.SemanticException;
import org.eclipse.emf.ocl.query.Query;
import org.eclipse.emf.ocl.query.QueryFactory;
import org.eclipse.emf.ocl.types.CollectionType;
import org.eclipse.emf.ocl.types.TypeType;
import org.eclipse.emf.ocl.types.impl.TypeUtil;
import org.eclipse.emf.ocl.types.util.Types;
import org.eclipse.gmf.internal.validate.DebugOptions;
import org.eclipse.gmf.internal.validate.DefUtils;
import org.eclipse.gmf.internal.validate.EDataTypeConversion;
import org.eclipse.gmf.internal.validate.GMFValidationPlugin;
import org.eclipse.gmf.internal.validate.Messages;
import org.eclipse.gmf.internal.validate.StatusCodes;
import org.eclipse.gmf.internal.validate.Trace;
import org.eclipse.gmf.internal.validate.expressions.AbstractExpression;
import org.eclipse.gmf.internal.validate.expressions.IEvaluationEnvironment;
import org.eclipse.gmf.internal.validate.expressions.IParseEnvironment;

class OCLExpressionAdapter
extends AbstractExpression {
    public static final String OCL = "ocl";
    private Query query;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.gmf.internal.validate.ocl.OCLExpressionAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public OCLExpressionAdapter(String body, EClassifier context, IParseEnvironment extEnv) {
        super(body, context, extEnv);
        try {
            if (extEnv == null) {
                this.query = QueryFactory.eINSTANCE.createQuery(body, context);
            } else {
                EnvironmentFactory factory = extEnv.getImportRegistry() == null ? EnvironmentFactory.ECORE_INSTANCE : new EcoreEnvironmentFactory(extEnv.getImportRegistry());
                Environment env = factory.createClassifierContext((Object)context);
                Iterator it = extEnv.getVariableNames().iterator();
                while (it.hasNext()) {
                    String varName = (String)it.next();
                    EClassifier type = extEnv.getTypeOf(varName);
                    Variable varDecl = ExpressionsFactory.eINSTANCE.createVariable();
                    varDecl.setName(varName);
                    varDecl.setType(type);
                    env.addElement(varDecl.getName(), varDecl, false);
                }
                OCLExpression oclExpression = ExpressionsUtil.createQuery((Environment)env, (String)body, (boolean)true);
                this.query = QueryFactory.eINSTANCE.createQuery(oclExpression);
            }
        }
        catch (ParserException e) {
            this.setInvalidOclExprStatus((Exception)((Object)e));
        }
        catch (IllegalArgumentException e) {
            this.setInvalidOclExprStatus(e);
        }
        catch (RuntimeException e) {
            this.setStatus(GMFValidationPlugin.createStatus(4, StatusCodes.UNEXPECTED_PARSE_ERROR, Messages.unexpectedExprParseError, e));
            GMFValidationPlugin.log(this.getStatus());
            Trace.catching(DebugOptions.EXCEPTIONS_CATCHING, e);
        }
    }

    public String getLanguage() {
        return OCL;
    }

    public boolean isLooselyTyped() {
        return false;
    }

    public boolean isAssignableTo(EClassifier ecoreType) {
        EClassifier oclType = EcoreEnvironment.getOCLType((EClassifier)ecoreType);
        if (oclType == null) {
            return false;
        }
        return this.isOclConformantTo(oclType);
    }

    public boolean isAssignableToElement(ETypedElement typedElement) {
        EClassifier oclType = EcoreEnvironment.getOCLType((ETypedElement)typedElement);
        if (oclType == null) {
            return false;
        }
        return this.isOclConformantTo(oclType);
    }

    public EClassifier getResultType() {
        return this.query != null ? this.query.getExpression().getType() : super.getResultType();
    }

    protected Object doEvaluate(Object context) {
        return OCLExpressionAdapter.filterOCLInvalid(this.query != null ? this.query.evaluate(context) : null);
    }

    protected Object doEvaluate(Object context, IEvaluationEnvironment extEnvironment) {
        return this.doEvaluate(context);
    }

    private static Object filterOCLInvalid(Object object) {
        return object == Types.OCL_INVALID ? null : object;
    }

    boolean isOclConformantTo(EClassifier anotherOclType) {
        EClassifier thisRefferedClassifier;
        CollectionType oclCollectionType;
        EClassifier thisOclType = this.getResultType();
        boolean isTargetCollection = anotherOclType instanceof CollectionType;
        if (isTargetCollection && (oclCollectionType = (CollectionType)anotherOclType).getElementType() != null) {
            anotherOclType = oclCollectionType.getElementType();
        }
        if (thisOclType instanceof CollectionType) {
            if (!isTargetCollection) {
                return false;
            }
            CollectionType thisOclCollectionType = (CollectionType)thisOclType;
            if (thisOclCollectionType.getElementType() != null) {
                thisOclType = thisOclCollectionType.getElementType();
            }
        }
        if (thisOclType instanceof TypeType && (thisRefferedClassifier = OCLExpressionAdapter.getReferredType(this.query.getExpression())) != null) {
            return DefUtils.getCanonicalEClassifier(anotherOclType).isInstance((Object)thisRefferedClassifier);
        }
        Class clazz = thisOclType.getInstanceClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2 || thisOclType.getInstanceClass() == Integer.TYPE) {
            Class clazz3 = anotherOclType.getInstanceClass();
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz3 == clazz4 || anotherOclType.getInstanceClass() == Double.TYPE) {
                return true;
            }
        }
        if (thisOclType instanceof EDataType && anotherOclType instanceof EDataType && EDataTypeConversion.isConvertable((EDataType)anotherOclType, (EDataType)thisOclType)) {
            return true;
        }
        return DefUtils.checkTypeAssignmentCompatibility(anotherOclType, thisOclType);
    }

    static EClassifier getReferredType(OCLExpression oclExpression) {
        EClassifier referredType = null;
        if (oclExpression instanceof TypeExp) {
            referredType = ((TypeExp)oclExpression).getReferredType();
        } else if (oclExpression instanceof CollectionLiteralExp) {
            Iterator it = ((CollectionLiteralExp)oclExpression).getPart().iterator();
            while (it.hasNext()) {
                CollectionLiteralPart nextPart = (CollectionLiteralPart)it.next();
                if (!(nextPart.getType() instanceof TypeType) || !(nextPart instanceof CollectionItem)) continue;
                EClassifier nextType = OCLExpressionAdapter.getReferredType(((CollectionItem)nextPart).getItem());
                if (referredType == null) {
                    referredType = nextType;
                    continue;
                }
                try {
                    if (nextType == null) continue;
                    referredType = TypeUtil.commonSuperType((EClassifier)referredType, (EClassifier)nextType);
                }
                catch (SemanticException semanticException) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return null;
                }
            }
        }
        return referredType;
    }

    void setInvalidOclExprStatus(Exception exception) {
        String message = MessageFormat.format(Messages.invalidExpressionBody, this.getBody(), exception.getLocalizedMessage());
        this.setStatus(GMFValidationPlugin.createStatus(4, StatusCodes.INVALID_VALUE_EXPRESSION, message, exception));
        Trace.catching(DebugOptions.EXCEPTIONS_CATCHING, exception);
    }
}

