/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml14.papyrusre.modellibrary.papyrusrestandardutils.requirementandprocessconcerns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SatisfactionStatusKind implements Enumerator
{
    NOT_SATISFIED(0, "NotSatisfied", "NotSatisfied"),
    SATISFIED(1, "Satisfied", "Satisfied"),
    SUSPECT(2, "Suspect", "Suspect");

    public static final int NOT_SATISFIED_VALUE = 0;
    public static final int SATISFIED_VALUE = 1;
    public static final int SUSPECT_VALUE = 2;
    private static final SatisfactionStatusKind[] VALUES_ARRAY;
    public static final List<SatisfactionStatusKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SatisfactionStatusKind[]{NOT_SATISFIED, SATISFIED, SUSPECT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SatisfactionStatusKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SatisfactionStatusKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SatisfactionStatusKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SatisfactionStatusKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SatisfactionStatusKind get(int value) {
        switch (value) {
            case 0: {
                return NOT_SATISFIED;
            }
            case 1: {
                return SATISFIED;
            }
            case 2: {
                return SUSPECT;
            }
        }
        return null;
    }

    private SatisfactionStatusKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

