/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml16.diagram.common.internal.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateChildViewOperation;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescriptionLanguage;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.AbstractRepresentation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.Representation;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.providers.ExpandViewProvider;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.ChildrenListRepresentation;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class SysML16ExpandViewProvider
extends ExpandViewProvider {
    private static final String SYSML_16 = "SysML 1.6";

    private boolean isAllowedLanguage(CreateChildViewOperation operation) {
        PapyrusRepresentationKind kind;
        Diagram diagram;
        ViewPrototype viewPrototype;
        View currentView = operation.getContainerView();
        if (currentView != null && (viewPrototype = DiagramUtils.getPrototype((Diagram)(diagram = currentView.getDiagram()))) != null && (kind = viewPrototype.getRepresentationKind()) != null && kind.getLanguage() != null) {
            ArchitectureDescriptionLanguage language = kind.getLanguage();
            return this.isAllowedLanguage(language.getName());
        }
        return false;
    }

    protected boolean isAllowedLanguage(String language) {
        return SYSML_16.equals(language);
    }

    protected String getNodeGraphicalType(IAdaptable semanticAdapter, View containerView, String semanticHint) {
        if (semanticHint == null) {
            String currentDiagramType = this.getDiagramType(containerView);
            String containerType = containerView.getType();
            List possibleChildrenIDs = (List)((ChildrenListRepresentation)this.diagramExpansionRegistry.mapChildreen.get((Object)currentDiagramType)).parentChildrenRelation.get(containerType);
            if (possibleChildrenIDs != null) {
                ArrayList<String> supportedChildrenIDs = new ArrayList<String>();
                for (String currentChildId : possibleChildrenIDs) {
                    ElementTypeConfiguration elementTypeConfiguration;
                    List<MetamodelTypeConfiguration> res;
                    ChildrenListRepresentation childrenListRepresentation = (ChildrenListRepresentation)this.diagramExpansionRegistry.mapChildreen.get(currentDiagramType);
                    AbstractRepresentation answer = (AbstractRepresentation)childrenListRepresentation.IDMap.get(currentChildId);
                    if (!(answer instanceof Representation) || (res = this.getSupportedMetamodelTypeConfiguration(semanticAdapter, elementTypeConfiguration = ((Representation)answer).getGraphicalElementTypeRef())).isEmpty()) continue;
                    supportedChildrenIDs.add(currentChildId);
                }
                if (supportedChildrenIDs.size() == 1) {
                    return (String)supportedChildrenIDs.get(0);
                }
            }
        }
        return null;
    }

    private List<MetamodelTypeConfiguration> getSupportedMetamodelTypeConfiguration(IAdaptable semanticAdapter, ElementTypeConfiguration elementTypeConfiguration) {
        ArrayList<MetamodelTypeConfiguration> metamodelTypeConfiguration = new ArrayList<MetamodelTypeConfiguration>();
        if (elementTypeConfiguration instanceof MetamodelTypeConfiguration) {
            EObject currentEObject;
            MetamodelTypeConfiguration mtc = (MetamodelTypeConfiguration)elementTypeConfiguration;
            EClass metamodelEClass = mtc.getEClass();
            if (metamodelEClass != null && metamodelEClass.isInstance((Object)(currentEObject = (EObject)semanticAdapter.getAdapter(EObject.class)))) {
                metamodelTypeConfiguration.add((MetamodelTypeConfiguration)elementTypeConfiguration);
            }
        } else if (elementTypeConfiguration instanceof SpecializationTypeConfiguration) {
            SpecializationTypeConfiguration stc = (SpecializationTypeConfiguration)elementTypeConfiguration;
            EList specialiedTypes = stc.getSpecializedTypes();
            for (ElementTypeConfiguration current : specialiedTypes) {
                List<MetamodelTypeConfiguration> result = this.getSupportedMetamodelTypeConfiguration(semanticAdapter, current);
                metamodelTypeConfiguration.addAll(result);
            }
        }
        return metamodelTypeConfiguration;
    }

    protected boolean providesFromExpansionModel(CreateChildViewOperation operation) {
        boolean result = false;
        String semanticHint = operation.getSemanticHint();
        if (this.isAllowedLanguage(operation) && (semanticHint == null || semanticHint.isEmpty())) {
            result = this.getNodeGraphicalType(operation.getSemanticAdapter(), operation.getContainerView(), semanticHint) != null;
        }
        return result;
    }
}

